/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl.types;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.tuscany.sca.binding.corba.impl.exceptions.RequestConfigurationException;
import org.apache.tuscany.sca.binding.corba.impl.types.AnnotationAttributes;
import org.apache.tuscany.sca.binding.corba.impl.types.NodeType;
import org.apache.tuscany.sca.binding.corba.impl.types.TypeTree;
import org.apache.tuscany.sca.binding.corba.impl.types.TypeTreeNode;
import org.apache.tuscany.sca.binding.corba.impl.types.UnionAttributes;
import org.apache.tuscany.sca.binding.corba.meta.CorbaArray;
import org.apache.tuscany.sca.binding.corba.meta.CorbaUnionElement;
import org.apache.tuscany.sca.binding.corba.meta.CorbaUnionElementType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeTreeCreator {
    private static List<Class<?>> primitives = new ArrayList();

    private static Class<?> createClassFromString(String name) {
        Class<Comparable<Boolean>> result = null;
        try {
            if (name.length() == 1) {
                switch (name.charAt(0)) {
                    case 'Z': {
                        result = Boolean.TYPE;
                        break;
                    }
                    case 'C': {
                        result = Character.TYPE;
                        break;
                    }
                    case 'B': {
                        result = Byte.TYPE;
                        break;
                    }
                    case 'S': {
                        result = Short.TYPE;
                        break;
                    }
                    case 'I': {
                        result = Integer.TYPE;
                        break;
                    }
                    case 'J': {
                        result = Long.TYPE;
                        break;
                    }
                    case 'F': {
                        result = Float.TYPE;
                        break;
                    }
                    case 'D': {
                        result = Double.TYPE;
                    }
                }
            } else {
                name = name.substring(1, name.length() - 1);
                result = Class.forName(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static Class<?> reduceArrayDimension(Class<?> forClass) {
        String name = forClass.getName();
        try {
            String reduced = name.substring(1, name.length());
            if (reduced.startsWith("[")) {
                return Class.forName(reduced);
            }
            return TypeTreeCreator.createClassFromString(reduced);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int[] removeFirstElement(int[] array) {
        int[] result = new int[array.length - 1];
        System.arraycopy(array, 1, result, 0, result.length);
        return result;
    }

    private static AnnotationAttributes createAnnotationAttributes(Annotation[] notes) {
        AnnotationAttributes attrs = new AnnotationAttributes();
        for (int i = 0; notes != null && i < notes.length; ++i) {
            if (!notes[i].annotationType().equals(CorbaArray.class)) continue;
            attrs.setCorbaArray(true);
            attrs.setCorbaArrayLength(((CorbaArray)notes[i]).value());
        }
        return attrs;
    }

    public static TypeTree createTypeTree(Class<?> forClass, Annotation[] notes) throws RequestConfigurationException {
        TypeTree tree = new TypeTree();
        TypeTreeNode rootNode = null;
        AnnotationAttributes attrs = TypeTreeCreator.createAnnotationAttributes(notes);
        rootNode = TypeTreeCreator.inspectClassHierarchy(forClass, attrs, tree);
        tree.setRootNode(rootNode);
        return tree;
    }

    private static TypeTreeNode inspectClassHierarchy(Class<?> forClass, AnnotationAttributes attributes, TypeTree tree) throws RequestConfigurationException {
        TypeTreeNode node = null;
        node = TypeTreeCreator.createTypeNode(forClass, attributes);
        NodeType nodeType = node.getNodeType();
        TypeTreeNode[] children = null;
        if (!nodeType.equals((Object)NodeType.primitive)) {
            if (nodeType.equals((Object)NodeType.array)) {
                Class<?> reduced = TypeTreeCreator.reduceArrayDimension(node.getJavaClass());
                children = new TypeTreeNode[1];
                int[] newLengths = TypeTreeCreator.removeFirstElement(attributes.getCorbaArrayLength());
                attributes.setCorbaArrayLength(newLengths);
                children[0] = TypeTreeCreator.inspectClassHierarchy(reduced, attributes, tree);
            } else if (nodeType.equals((Object)NodeType.sequence)) {
                Class<?> reduced = TypeTreeCreator.reduceArrayDimension(node.getJavaClass());
                children = new TypeTreeNode[]{TypeTreeCreator.inspectClassHierarchy(reduced, attributes, tree)};
            } else if (nodeType.equals((Object)NodeType.struct) || nodeType.equals((Object)NodeType.exception)) {
                Field[] fields = node.getJavaClass().getFields();
                children = new TypeTreeNode[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Class<?> field = fields[i].getType();
                    AnnotationAttributes fAttrs = TypeTreeCreator.createAnnotationAttributes(fields[i].getAnnotations());
                    TypeTreeNode child = TypeTreeCreator.inspectClassHierarchy(field, fAttrs, tree);
                    child.setName(fields[i].getName());
                    children[i] = child;
                }
            } else if (!nodeType.equals((Object)NodeType.idl_enum)) {
                if (nodeType.equals((Object)NodeType.union)) {
                    Field[] fields = node.getJavaClass().getDeclaredFields();
                    children = new TypeTreeNode[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        Class<?> field = fields[i].getType();
                        AnnotationAttributes fAttrs = TypeTreeCreator.createAnnotationAttributes(fields[i].getAnnotations());
                        TypeTreeNode child = TypeTreeCreator.inspectClassHierarchy(field, fAttrs, tree);
                        child.setName(fields[i].getName());
                        children[i] = child;
                    }
                } else if (nodeType.equals((Object)NodeType.reference)) {
                    // empty if block
                }
            }
        }
        node.setChildren(children);
        return node;
    }

    private static TypeTreeNode createTypeNode(Class<?> forClass, AnnotationAttributes attributes) throws RequestConfigurationException {
        TypeTreeNode node = new TypeTreeNode();
        if (forClass.isArray() && !attributes.isCorbaArray()) {
            node.setNodeType(NodeType.sequence);
            node.setJavaClass(forClass);
        } else if (forClass.isArray() && attributes.isCorbaArray()) {
            node.setNodeType(NodeType.array);
            node.setJavaClass(forClass);
            try {
                node.setAttributes(attributes.getCorbaArrayLength()[0]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                RequestConfigurationException exc = new RequestConfigurationException("Annotated array size doesn't match declared arrays size");
                throw exc;
            }
        } else if (primitives.contains(forClass)) {
            node.setNodeType(NodeType.primitive);
            node.setJavaClass(forClass);
            node.setChildren(null);
        } else if (forClass.isInterface()) {
            node.setNodeType(NodeType.reference);
            node.setJavaClass(forClass);
            node.setChildren(null);
        } else if (TypeTreeCreator.isStructType(forClass)) {
            node.setNodeType(NodeType.struct);
            node.setJavaClass(forClass);
        } else if (TypeTreeCreator.isEnumType(forClass)) {
            node.setNodeType(NodeType.idl_enum);
            node.setJavaClass(forClass);
        } else if (TypeTreeCreator.isUserException(forClass)) {
            node.setNodeType(NodeType.exception);
            node.setJavaClass(forClass);
        } else if (TypeTreeCreator.isUnionType(forClass)) {
            node.setNodeType(NodeType.union);
            node.setJavaClass(forClass);
            node.setAttributes(TypeTreeCreator.getUnionAttributes(forClass));
        } else {
            RequestConfigurationException e = new RequestConfigurationException("User defined type which cannot be handled: " + forClass.getCanonicalName());
            throw e;
        }
        return node;
    }

    private static boolean isStructType(Class<?> forClass) {
        int classMods = forClass.getModifiers();
        if (!Modifier.isFinal(classMods)) {
            return false;
        }
        boolean areCtorsValid = false;
        Class<?>[] fieldsTypes = null;
        Constructor<?>[] ctors = forClass.getConstructors();
        if (ctors.length != 2) {
            return false;
        }
        for (int i = 0; i < ctors.length; ++i) {
            Class<?>[] params = ctors[i].getParameterTypes();
            if (params.length == 0) {
                areCtorsValid = true;
                continue;
            }
            fieldsTypes = params;
        }
        if (!areCtorsValid) {
            return false;
        }
        Field[] fields = forClass.getFields();
        HashSet fieldsSet = new HashSet(Arrays.asList(fieldsTypes));
        for (int i = 0; i < fields.length && !fieldsSet.isEmpty(); ++i) {
            int mods = fields[i].getModifiers();
            if (!Modifier.isPublic(mods) || Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
            fieldsSet.remove(fields[i].getType());
        }
        return fieldsSet.isEmpty();
    }

    private static boolean isEnumType(Class<?> forClass) {
        boolean isValueMethod = false;
        boolean isFromIntMethod = false;
        try {
            Method valueMet = forClass.getMethod("value", new Class[0]);
            int modValueMet = valueMet.getModifiers();
            if (valueMet.getReturnType().equals(Integer.TYPE) && Modifier.isPublic(modValueMet)) {
                isValueMethod = true;
            }
            Method fromIntMet = forClass.getMethod("from_int", Integer.TYPE);
            int modFromIntMet = fromIntMet.getModifiers();
            if (fromIntMet.getReturnType().equals(forClass) && Modifier.isPublic(modFromIntMet) && Modifier.isStatic(modFromIntMet)) {
                isFromIntMethod = true;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (!isFromIntMethod || !isValueMethod) {
            return false;
        }
        int enumCount = 0;
        Field[] fields = forClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            int modifiers;
            if (!fields[i].getType().equals(forClass) || !Modifier.isStatic(modifiers = fields[i].getModifiers()) || !Modifier.isPublic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            try {
                Field field = forClass.getField("_" + fields[i].getName());
                if (!field.getType().equals(Integer.TYPE)) continue;
                ++enumCount;
                continue;
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        return enumCount > 0;
    }

    private static boolean isUserException(Class<?> forClass) {
        do {
            if (!forClass.equals(Exception.class)) continue;
            return true;
        } while ((forClass = forClass.getSuperclass()) != null && !forClass.equals(Object.class));
        return false;
    }

    private static boolean isUnionType(Class<?> forClass) throws RequestConfigurationException {
        int classMods = forClass.getModifiers();
        if (!Modifier.isFinal(classMods)) {
            return false;
        }
        boolean atLeastOneOption = false;
        boolean discriminatorPresent = false;
        for (int i = 0; i < forClass.getDeclaredFields().length; ++i) {
            CorbaUnionElement note = forClass.getDeclaredFields()[i].getAnnotation(CorbaUnionElement.class);
            if (note == null) continue;
            int fieldMod = forClass.getDeclaredFields()[i].getModifiers();
            if (Modifier.isPrivate(fieldMod) && !Modifier.isFinal(fieldMod) && !Modifier.isStatic(fieldMod)) {
                if (note.type().equals((Object)CorbaUnionElementType.discriminator)) {
                    if (discriminatorPresent) {
                        throw new RequestConfigurationException("More than one discriminators declared on: " + forClass);
                    }
                    discriminatorPresent = true;
                    continue;
                }
                atLeastOneOption = true;
                continue;
            }
            throw new RequestConfigurationException("Annotated union field should be private, not final and no static on class: " + forClass);
        }
        if (atLeastOneOption && !discriminatorPresent) {
            throw new RequestConfigurationException("No discriminator annotation found on: " + forClass);
        }
        if (!atLeastOneOption && discriminatorPresent) {
            throw new RequestConfigurationException("No union option found on: " + forClass);
        }
        return discriminatorPresent && atLeastOneOption;
    }

    private static UnionAttributes getUnionAttributes(Class<?> forClass) throws RequestConfigurationException {
        UnionAttributes attributes = new UnionAttributes();
        for (int i = 0; i < forClass.getDeclaredFields().length; ++i) {
            CorbaUnionElement note = forClass.getDeclaredFields()[i].getAnnotation(CorbaUnionElement.class);
            if (note == null) continue;
            if (note.type().equals((Object)CorbaUnionElementType.discriminator)) {
                attributes.setDiscriminatorName(forClass.getDeclaredFields()[i].getName());
                continue;
            }
            if (note.type().equals((Object)CorbaUnionElementType.defaultOption)) {
                attributes.setDefaultOptionName(forClass.getDeclaredFields()[i].getName());
                continue;
            }
            if (!note.type().equals((Object)CorbaUnionElementType.option)) continue;
            if (attributes.getOptionsMapping().containsKey(note.optionNumber())) {
                throw new RequestConfigurationException("In " + forClass + ": field \"" + forClass.getDeclaredFields()[i].getName() + "\" uses already used option id: " + note.optionNumber());
            }
            attributes.getOptionsMapping().put(note.optionNumber(), forClass.getDeclaredFields()[i].getName());
        }
        return attributes;
    }

    static {
        primitives.add(Boolean.TYPE);
        primitives.add(Byte.TYPE);
        primitives.add(Short.TYPE);
        primitives.add(Integer.TYPE);
        primitives.add(Long.TYPE);
        primitives.add(Double.TYPE);
        primitives.add(Float.TYPE);
        primitives.add(Character.TYPE);
        primitives.add(String.class);
        primitives.add(Boolean.class);
        primitives.add(Byte.class);
        primitives.add(Short.class);
        primitives.add(Integer.class);
        primitives.add(Long.class);
        primitives.add(Double.class);
        primitives.add(Float.class);
        primitives.add(Character.class);
    }
}

