/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl.types.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.binding.corba.impl.types.NodeType;
import org.apache.tuscany.sca.binding.corba.impl.types.TypeTreeNode;
import org.apache.tuscany.sca.binding.corba.impl.types.util.ArrayTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.BooleanTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.ByteTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.CharTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.DoubleTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.EnumTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.FloatTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.IntTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.LongTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.ReferenceTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.SequenceTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.ShortTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.StringTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.StructTypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.TypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.UnionTypeHelper;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class TypeHelpersProxy {
    private static Map<Class<?>, TypeHelper> primitiveTypes = null;
    private static Map<NodeType, TypeHelper> complexTypes = null;

    private static TypeHelper getTypeHelper(TypeTreeNode node) {
        TypeHelper typeHelper = null;
        NodeType type = node.getNodeType();
        typeHelper = type.equals((Object)NodeType.primitive) ? primitiveTypes.get(node.getJavaClass()) : complexTypes.get((Object)type);
        return typeHelper;
    }

    public static final Object read(TypeTreeNode node, InputStream is) {
        TypeHelper helper = TypeHelpersProxy.getTypeHelper(node);
        return helper.read(node, is);
    }

    public static final void write(TypeTreeNode node, OutputStream os, Object data) {
        TypeHelper helper = TypeHelpersProxy.getTypeHelper(node);
        helper.write(node, os, data);
    }

    static {
        primitiveTypes = new HashMap();
        complexTypes = new HashMap<NodeType, TypeHelper>();
        primitiveTypes.put(Boolean.TYPE, new BooleanTypeHelper());
        primitiveTypes.put(Character.TYPE, new CharTypeHelper());
        primitiveTypes.put(Byte.TYPE, new ByteTypeHelper());
        primitiveTypes.put(Short.TYPE, new ShortTypeHelper());
        primitiveTypes.put(Integer.TYPE, new IntTypeHelper());
        primitiveTypes.put(Long.TYPE, new LongTypeHelper());
        primitiveTypes.put(Float.TYPE, new FloatTypeHelper());
        primitiveTypes.put(Double.TYPE, new DoubleTypeHelper());
        primitiveTypes.put(String.class, new StringTypeHelper());
        primitiveTypes.put(Boolean.class, primitiveTypes.get(Boolean.TYPE));
        primitiveTypes.put(Character.class, primitiveTypes.get(Character.TYPE));
        primitiveTypes.put(Byte.class, primitiveTypes.get(Byte.TYPE));
        primitiveTypes.put(Short.class, primitiveTypes.get(Short.TYPE));
        primitiveTypes.put(Integer.class, primitiveTypes.get(Integer.TYPE));
        primitiveTypes.put(Long.class, primitiveTypes.get(Long.TYPE));
        primitiveTypes.put(Float.class, primitiveTypes.get(Float.TYPE));
        primitiveTypes.put(Double.class, primitiveTypes.get(Double.TYPE));
        primitiveTypes.put(String.class, primitiveTypes.get(String.class));
        complexTypes.put(NodeType.array, new ArrayTypeHelper());
        complexTypes.put(NodeType.struct, new StructTypeHelper());
        complexTypes.put(NodeType.reference, new ReferenceTypeHelper());
        complexTypes.put(NodeType.sequence, new SequenceTypeHelper());
        complexTypes.put(NodeType.idl_enum, new EnumTypeHelper());
        complexTypes.put(NodeType.exception, new StructTypeHelper());
        complexTypes.put(NodeType.union, new UnionTypeHelper());
    }
}

