/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodFinder {
    private static Map<Class<?>, Class<?>> boxingMapping = new HashMap();

    private static Class<?> normalizePrimitive(Class<?> parameter) {
        Class<?> result = boxingMapping.get(parameter);
        if (result != null) {
            return result;
        }
        return parameter;
    }

    public static Method findMethod(Class<?> forClass, String methodName, Class<?>[] parameterTypes) {
        Method[] methods = forClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] methodPTypes;
            if (!methods[i].getName().equals(methodName) || (methodPTypes = methods[i].getParameterTypes()).length != parameterTypes.length) continue;
            boolean parameterMatch = true;
            for (int j = 0; j < methodPTypes.length; ++j) {
                Class<?> nParameterType;
                Class<?> nMethodPType = MethodFinder.normalizePrimitive(methodPTypes[j]);
                if (nMethodPType.equals(nParameterType = MethodFinder.normalizePrimitive(parameterTypes[j]))) continue;
                parameterMatch = false;
                break;
            }
            if (!parameterMatch) continue;
            return methods[i];
        }
        return null;
    }

    static {
        boxingMapping.put(Boolean.TYPE, Boolean.class);
        boxingMapping.put(Byte.TYPE, Byte.class);
        boxingMapping.put(Short.TYPE, Short.class);
        boxingMapping.put(Character.TYPE, Character.class);
        boxingMapping.put(Integer.TYPE, Integer.class);
        boxingMapping.put(Long.TYPE, Long.class);
        boxingMapping.put(Float.TYPE, Float.class);
        boxingMapping.put(Double.TYPE, Double.class);
    }
}

