/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl.util;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.omg.CORBA.portable.IDLEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationMapper {
    private static final Map<String, String> specialTypeNames = new HashMap<String, String>();
    private static final Map<String, String> specialTypePackages;
    private static final Set<String> keywords;

    private static Set<Class<?>> getAllInterfaces(Class<?> intfClass) {
        LinkedHashSet allInterfaces = new LinkedHashSet();
        LinkedList stack = new LinkedList();
        stack.addFirst(intfClass);
        while (!stack.isEmpty()) {
            Class intf = (Class)stack.removeFirst();
            allInterfaces.add(intf);
            for (Class<?> i : intf.getInterfaces()) {
                stack.add(0, i);
            }
        }
        return allInterfaces;
    }

    public static Map<Method, String> mapMethodToOperationName(Class<?> intfClass) {
        return OperationMapper.iiopMap(intfClass, false);
    }

    public static Map<String, Method> mapOperationNameToMethod(Class<?> intfClass) {
        return OperationMapper.iiopMap(intfClass, true);
    }

    private static Map iiopMap(Class<?> intfClass, boolean operationToMethod) {
        Class<?> exceptionType;
        Class<?>[] exceptionTypes;
        boolean exceptionsValid;
        Method[] methods = OperationMapper.getAllMethods(intfClass);
        HashMap<Method, String> getterByMethod = new HashMap<Method, String>(methods.length);
        HashMap<String, Method> getterByName = new HashMap<String, Method>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            String verb;
            Method method = methods[i];
            String methodName = method.getName();
            if (method.getParameterTypes().length != 0) continue;
            if (methodName.startsWith("get") && methodName.length() > 3 && method.getReturnType() != Void.TYPE) {
                verb = "get";
            } else {
                if (!methodName.startsWith("is") || methodName.length() <= 2 || method.getReturnType() != Boolean.TYPE) continue;
                verb = "is";
            }
            exceptionsValid = true;
            exceptionTypes = method.getExceptionTypes();
            for (int j = 0; j < exceptionTypes.length; ++j) {
                exceptionType = exceptionTypes[j];
                if (RemoteException.class.isAssignableFrom(exceptionType) || RuntimeException.class.isAssignableFrom(exceptionType) || Error.class.isAssignableFrom(exceptionType)) continue;
                exceptionsValid = false;
                break;
            }
            if (!exceptionsValid) continue;
            String propertyName = methodName.length() > verb.length() + 1 && Character.isUpperCase(methodName.charAt(verb.length() + 1)) ? methodName.substring(verb.length()) : Character.toLowerCase(methodName.charAt(verb.length())) + methodName.substring(verb.length() + 1);
            getterByMethod.put(method, propertyName);
            getterByName.put(propertyName, method);
        }
        HashMap<Method, String> setterByMethod = new HashMap<Method, String>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            Method getter;
            Method method = methods[i];
            String methodName = method.getName();
            if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE || !methodName.startsWith("set") || methodName.length() <= 3) continue;
            exceptionsValid = true;
            exceptionTypes = method.getExceptionTypes();
            for (int j = 0; j < exceptionTypes.length; ++j) {
                exceptionType = exceptionTypes[j];
                if (RemoteException.class.isAssignableFrom(exceptionType) || RuntimeException.class.isAssignableFrom(exceptionType) || Error.class.isAssignableFrom(exceptionType)) continue;
                exceptionsValid = false;
                break;
            }
            if (!exceptionsValid || (getter = (Method)getterByName.get(propertyName = methodName.length() > 4 && Character.isUpperCase(methodName.charAt(4)) ? methodName.substring(3) : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4))) == null || !method.getParameterTypes()[0].equals(getter.getReturnType())) continue;
            setterByMethod.put(method, propertyName);
        }
        HashMap<String, LinkedList<Method>> overloadedMethods = new HashMap<String, LinkedList<Method>>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (getterByMethod.containsKey(method) || setterByMethod.containsKey(method)) continue;
            String methodName = method.getName();
            LinkedList<Method> methodList = (LinkedList<Method>)overloadedMethods.get(methodName);
            if (methodList == null) {
                methodList = new LinkedList<Method>();
                overloadedMethods.put(methodName, methodList);
            }
            methodList.add(method);
        }
        HashMap<String, HashSet<String>> caseCollisionMethods = new HashMap<String, HashSet<String>>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (getterByMethod.containsKey(method) || setterByMethod.containsKey(method)) continue;
            String lowerCaseMethodName = method.getName().toLowerCase();
            HashSet<String> methodSet = (HashSet<String>)caseCollisionMethods.get(lowerCaseMethodName);
            if (methodSet == null) {
                methodSet = new HashSet<String>();
                caseCollisionMethods.put(lowerCaseMethodName, methodSet);
            }
            methodSet.add(method.getName());
        }
        String className = OperationMapper.getClassName(intfClass);
        HashMap<Object, Object> iiopMap = new HashMap<Object, Object>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            List overloads;
            Method method = methods[i];
            String iiopName = (String)getterByMethod.get(method);
            if (iiopName != null) {
                iiopName = iiopName.charAt(0) == '_' ? "J_get_" + iiopName.substring(1) : "_get_" + iiopName;
            } else {
                iiopName = (String)setterByMethod.get(method);
                if (iiopName != null) {
                    iiopName = iiopName.charAt(0) == '_' ? "J_set_" + iiopName.substring(1) : "_set_" + iiopName;
                } else {
                    iiopName = method.getName();
                    if (iiopName.charAt(0) == '_') {
                        iiopName = "J" + iiopName;
                    }
                }
            }
            Set caseCollisions = (Set)caseCollisionMethods.get(method.getName().toLowerCase());
            if (caseCollisions != null && caseCollisions.size() > 1) {
                iiopName = iiopName + OperationMapper.upperCaseIndexString(iiopName);
            }
            if ((overloads = (List)overloadedMethods.get(method.getName())) != null && overloads.size() > 1) {
                iiopName = iiopName + OperationMapper.buildOverloadParameterString(method.getParameterTypes());
            }
            if (keywords.contains((iiopName = OperationMapper.replace(iiopName, '$', "U0024")).toLowerCase())) {
                iiopName = "_" + iiopName;
            }
            if (iiopName.equalsIgnoreCase(className)) {
                iiopName = iiopName + "_";
            }
            if (operationToMethod) {
                iiopMap.put(iiopName, method);
                continue;
            }
            iiopMap.put(method, iiopName);
        }
        return iiopMap;
    }

    private static Method[] getAllMethods(Class<?> intfClass) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Class<?> intf : OperationMapper.getAllInterfaces(intfClass)) {
            methods.addAll(Arrays.asList(intf.getDeclaredMethods()));
        }
        return methods.toArray(new Method[methods.size()]);
    }

    private static String upperCaseIndexString(String iiopName) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < iiopName.length(); ++i) {
            char c = iiopName.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            stringBuffer.append('_').append(i);
        }
        return stringBuffer.toString();
    }

    private static String replace(String source, char oldChar, String newString) {
        StringBuffer stringBuffer = new StringBuffer(source.length());
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == oldChar) {
                stringBuffer.append(newString);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String buildOverloadParameterString(Class<?>[] parameterTypes) {
        String name = "";
        if (parameterTypes.length == 0) {
            name = name + "__";
        } else {
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterType = parameterTypes[i];
                name = name + OperationMapper.buildOverloadParameterString(parameterType);
            }
        }
        return name.replace('.', '_');
    }

    private static String buildOverloadParameterString(Class<?> parameterType) {
        String className;
        String packageName;
        String name = "_";
        int arrayDimensions = 0;
        while (parameterType.isArray()) {
            ++arrayDimensions;
            parameterType = parameterType.getComponentType();
        }
        if (arrayDimensions > 0) {
            name = name + "_org_omg_boxedRMI";
        }
        if (IDLEntity.class.isAssignableFrom(parameterType)) {
            name = name + "_org_omg_boxedIDL";
        }
        if ((packageName = specialTypePackages.get(parameterType.getName())) == null) {
            packageName = OperationMapper.getPackageName(parameterType.getName());
        }
        if (packageName.length() > 0) {
            name = name + "_" + packageName;
        }
        if (arrayDimensions > 0) {
            name = name + "_seq" + arrayDimensions;
        }
        if ((className = specialTypeNames.get(parameterType.getName())) == null) {
            className = OperationMapper.buildClassName(parameterType);
        }
        name = name + "_" + className;
        return name;
    }

    private static String buildClassName(Class<?> type) {
        if (type.isArray()) {
            throw new IllegalArgumentException("type is an array: " + type);
        }
        String typeName = type.getName();
        int endIndex = typeName.lastIndexOf(46);
        if (endIndex < 0) {
            return typeName;
        }
        StringBuffer className = new StringBuffer(typeName.substring(endIndex + 1));
        if (type.getDeclaringClass() != null) {
            String declaringClassName = OperationMapper.getClassName(type.getDeclaringClass());
            assert (className.toString().startsWith(declaringClassName + "$"));
            className.replace(declaringClassName.length(), declaringClassName.length() + 1, "__");
        }
        if (className.charAt(0) == '_') {
            className.insert(0, "J");
        }
        return className.toString();
    }

    private static String getClassName(Class<?> type) {
        if (type.isArray()) {
            throw new IllegalArgumentException("type is an array: " + type);
        }
        String typeName = type.getName();
        int endIndex = typeName.lastIndexOf(46);
        if (endIndex < 0) {
            return typeName;
        }
        return typeName.substring(endIndex + 1);
    }

    private static String getPackageName(String interfaceName) {
        int endIndex = interfaceName.lastIndexOf(46);
        if (endIndex < 0) {
            return "";
        }
        return interfaceName.substring(0, endIndex);
    }

    public static Map<Operation, Method> mapOperationToMethod(List<Operation> operations, Class<?> forClass) {
        return OperationMapper.createMethod2OperationMapping(operations, forClass, false);
    }

    public static Map<Method, Operation> mapMethodToOperation(List<Operation> operations, Class<?> forClass) {
        return OperationMapper.createMethod2OperationMapping(operations, forClass, true);
    }

    private static Map createMethod2OperationMapping(List<Operation> operations, Class<?> forClass, boolean method2operation) {
        HashMap<Object, Object> mapping = new HashMap<Object, Object>();
        block0: for (Operation operation : operations) {
            List<DataType> inputTypes = operation.getInputType().getLogical();
            Method[] methods = forClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(operation.getName()) || inputTypes.size() != methods[i].getParameterTypes().length) continue;
                Class<?>[] parameterTypes = methods[i].getParameterTypes();
                int j = 0;
                boolean parameterMatch = true;
                for (DataType dataType : inputTypes) {
                    if (!dataType.getPhysical().equals(parameterTypes[j])) {
                        parameterMatch = false;
                        break;
                    }
                    ++j;
                }
                if (!parameterMatch) continue;
                if (method2operation) {
                    mapping.put(methods[i], operation);
                    continue block0;
                }
                mapping.put(operation, methods[i]);
                continue block0;
            }
        }
        return mapping;
    }

    static {
        specialTypeNames.put("boolean", "boolean");
        specialTypeNames.put("char", "wchar");
        specialTypeNames.put("byte", "octet");
        specialTypeNames.put("short", "short");
        specialTypeNames.put("int", "long");
        specialTypeNames.put("long", "long_long");
        specialTypeNames.put("float", "float");
        specialTypeNames.put("double", "double");
        specialTypeNames.put("java.lang.Class", "ClassDesc");
        specialTypeNames.put("java.lang.String", "WStringValue");
        specialTypeNames.put("org.omg.CORBA.Object", "Object");
        specialTypePackages = new HashMap<String, String>();
        specialTypePackages.put("boolean", "");
        specialTypePackages.put("char", "");
        specialTypePackages.put("byte", "");
        specialTypePackages.put("short", "");
        specialTypePackages.put("int", "");
        specialTypePackages.put("long", "");
        specialTypePackages.put("float", "");
        specialTypePackages.put("double", "");
        specialTypePackages.put("java.lang.Class", "javax.rmi.CORBA");
        specialTypePackages.put("java.lang.String", "CORBA");
        specialTypePackages.put("org.omg.CORBA.Object", "");
        keywords = new HashSet<String>();
        keywords.add("abstract");
        keywords.add("any");
        keywords.add("attribute");
        keywords.add("boolean");
        keywords.add("case");
        keywords.add("char");
        keywords.add("const");
        keywords.add("context");
        keywords.add("custom");
        keywords.add("default");
        keywords.add("double");
        keywords.add("enum");
        keywords.add("exception");
        keywords.add("factory");
        keywords.add("false");
        keywords.add("fixed");
        keywords.add("float");
        keywords.add("in");
        keywords.add("inout");
        keywords.add("interface");
        keywords.add("long");
        keywords.add("module");
        keywords.add("native");
        keywords.add("object");
        keywords.add("octet");
        keywords.add("oneway");
        keywords.add("out");
        keywords.add("private");
        keywords.add("public");
        keywords.add("raises");
        keywords.add("readonly");
        keywords.add("sequence");
        keywords.add("short");
        keywords.add("string");
        keywords.add("struct");
        keywords.add("supports");
        keywords.add("switch");
        keywords.add("true");
        keywords.add("truncatable");
        keywords.add("typedef");
        keywords.add("union");
        keywords.add("unsigned");
        keywords.add("valuebase");
        keywords.add("valuetype");
        keywords.add("void");
        keywords.add("wchar");
        keywords.add("wstring");
    }
}

