/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.dwr;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.servlet.Servlet;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.dwr.DWRBinding;
import org.apache.tuscany.sca.binding.dwr.DWRServlet;
import org.apache.tuscany.sca.extension.helper.ComponentLifecycle;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class DWRService
implements ComponentLifecycle {
    private RuntimeComponent rc;
    private RuntimeComponentService rcs;
    private Binding binding;
    private ServletHost servletHost;
    static final String SERVLET_PATH = "/SCADomain/*";

    public DWRService(RuntimeComponent rc, RuntimeComponentService rcs, Binding binding, DWRBinding ab, ServletHost servletHost) {
        this.rc = rc;
        this.rcs = rcs;
        this.binding = binding;
        this.servletHost = servletHost;
    }

    public void start() {
        DWRServlet servlet = (DWRServlet)this.servletHost.getServletMapping(SERVLET_PATH);
        if (servlet == null) {
            servlet = new DWRServlet();
            this.servletHost.addServletMapping(SERVLET_PATH, (Servlet)servlet);
        }
        Class<?> type = ((JavaInterface)this.rcs.getInterfaceContract().getInterface()).getJavaClass();
        Object proxy = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RuntimeWire wire = DWRService.this.rcs.getRuntimeWire(DWRService.this.binding);
                Operation op = JavaInterfaceUtil.findOperation(method, DWRService.this.rcs.getInterfaceContract().getInterface().getOperations());
                return wire.invoke(op, args);
            }
        });
        servlet.addService(this.binding.getName(), type, proxy);
    }

    public void stop() {
        this.servletHost.removeServletMapping(SERVLET_PATH);
    }
}

