/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.dwr;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.Container;
import org.directwebremoting.create.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.servlet.DwrServlet;
import org.directwebremoting.servlet.EngineHandler;
import org.directwebremoting.servlet.UrlProcessor;

public class DWRServlet
extends DwrServlet {
    private static final long serialVersionUID = 1L;
    private transient Map<String, ServiceHolder> services = new HashMap<String, ServiceHolder>();
    private transient List<String> referenceNames = new ArrayList<String>();
    private transient boolean initialized;
    private transient Map<String, String> initParams = new HashMap<String, String>();
    private static final String SCADOMAIN_SCRIPT_PATH = "/scaDomain.js";

    public DWRServlet() {
        this.initParams.put("activeReverseAjaxEnabled", "true");
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        if (!this.initialized) {
            super.init(this.patchConfig(servletConfig));
            this.addScriptHandler();
            this.initServices();
            this.initialized = true;
        }
    }

    private void addScriptHandler() {
        UrlProcessor urlProcessor = (UrlProcessor)this.getContainer().getBean(UrlProcessor.class.getName());
        final EngineHandler engineHandler = (EngineHandler)this.getContainer().getBean("url:/engine.js");
        final Handler scaDomainScriptHandler = new Handler(){

            public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
                PrintWriter out = response.getWriter();
                out.println("/** Apache Tuscany scaDomain.js Header */");
                engineHandler.handle(request, response);
                DWRServlet.this.tuscanyFooter(request, out);
            }
        };
        urlProcessor.afterContainerSetup(new Container(){

            public Object getBean(String name) {
                return scaDomainScriptHandler;
            }

            public Collection getBeanNames() {
                return Arrays.asList("url:/scaDomain.js");
            }
        });
    }

    private void tuscanyFooter(HttpServletRequest request, PrintWriter out) {
        out.println("/** Apache Tuscany scaDomain.js Footer */");
        out.println();
        out.println("function scaDomain() { }");
        out.println();
        out.println("// SCA services");
        Remoter remoter = (Remoter)this.getContainer().getBean(Remoter.class.getName());
        String path = request.getContextPath() + request.getServletPath();
        for (String serviceName : this.services.keySet()) {
            String serviceScript = remoter.generateInterfaceScript(serviceName, path);
            out.println(serviceScript);
        }
        if (this.referenceNames.size() > 0) {
            out.println("// SCA reverse ajax control functions");
            out.println();
            out.println("scaDomain.open = function() { dwr.engine.setActiveReverseAjax(true); };");
            out.println("scaDomain.close = function() { dwr.engine.setActiveReverseAjax(false); };");
            out.println();
            out.println("// SCA references");
            out.println();
            for (String referenceName : this.referenceNames) {
                out.println("function " + referenceName + "() { }");
            }
        }
        out.println();
        out.println("/** End of Apache Tuscany scaDomain.js */");
        out.println();
    }

    public void addReference(String name) {
        this.referenceNames.add(name);
    }

    public void addService(String name, Class type, Object instance) {
        ServiceHolder holder = new ServiceHolder();
        holder.name = name;
        holder.type = type;
        holder.instance = instance;
        this.services.put(name, holder);
    }

    private void initServices() {
        CreatorManager creatorManager = (CreatorManager)this.getContainer().getBean(CreatorManager.class.getName());
        for (final ServiceHolder holder : this.services.values()) {
            creatorManager.addCreator(holder.name, (Creator)new AbstractCreator(){

                public Class getType() {
                    return holder.type;
                }

                public Object getInstance() throws InstantiationException {
                    return holder.instance;
                }
            });
        }
    }

    private ServletConfig patchConfig(final ServletConfig servletConfig) {
        ServletConfig patchedContext = new ServletConfig(){

            public String getInitParameter(String name) {
                return (String)DWRServlet.this.initParams.get(name);
            }

            public Enumeration getInitParameterNames() {
                return Collections.enumeration(DWRServlet.this.initParams.keySet());
            }

            public ServletContext getServletContext() {
                return servletConfig.getServletContext();
            }

            public String getServletName() {
                return servletConfig.getServletName();
            }
        };
        return patchedContext;
    }

    private class ServiceHolder {
        String name;
        Class type;
        Object instance;

        private ServiceHolder() {
        }
    }
}

