/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.corba;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class ClassLoadingUtil {
    private static final HashMap PRIMITIVE_CLASS_MAP = new HashMap();
    private static final HashMap CLASS_TO_SIGNATURE_MAP = new HashMap();

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is null");
        }
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ignore) {
            Class resolvedClass = (Class)PRIMITIVE_CLASS_MAP.get(className);
            if (resolvedClass != null) {
                return resolvedClass;
            }
            if (className.endsWith(";") && className.startsWith("L")) {
                String typeName = className.substring(1, className.length() - 1);
                return classLoader.loadClass(typeName);
            }
            if (className.charAt(0) == '[') {
                int count;
                int nameLen = className.length();
                for (count = 0; count < nameLen && className.charAt(count) == '['; ++count) {
                }
                String arrayTypeName = className.substring(count, className.length());
                Class arrayType = ClassLoadingUtil.loadClass(arrayTypeName, classLoader);
                return ClassLoadingUtil.getArrayClass(arrayType, count);
            }
            if (className.endsWith("[]")) {
                int position;
                int count = 0;
                for (position = className.length(); position > 1 && className.substring(position - 2, position).equals("[]"); position -= 2) {
                    ++count;
                }
                String typeName = className.substring(0, position);
                Class arrayType = ClassLoadingUtil.loadClass(typeName, classLoader);
                return ClassLoadingUtil.getArrayClass(arrayType, count);
            }
            throw new ClassNotFoundException("Could not load class " + className + " from unknown classloader; " + classLoader);
        }
    }

    public static String getClassName(Class type) {
        StringBuffer name = new StringBuffer();
        while (type.isArray()) {
            name.append('[');
            type = type.getComponentType();
        }
        if (type.isPrimitive()) {
            name.append((String)CLASS_TO_SIGNATURE_MAP.get(type));
        } else {
            name.append('L');
            name.append(type.getName());
            name.append(';');
        }
        return name.toString();
    }

    private static Class getArrayClass(Class type, int dimension) {
        int[] dimensions = new int[dimension];
        return Array.newInstance(type, dimensions).getClass();
    }

    public static Set getAllTypes(Class type) {
        LinkedHashSet<Class> allTypes = new LinkedHashSet<Class>();
        allTypes.add(type);
        allTypes.addAll(ClassLoadingUtil.getAllSuperClasses(type));
        allTypes.addAll(ClassLoadingUtil.getAllInterfaces(type));
        return allTypes;
    }

    private static Set getAllSuperClasses(Class clazz) {
        LinkedHashSet allSuperClasses = new LinkedHashSet();
        for (Class superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            allSuperClasses.add(superClass);
        }
        return allSuperClasses;
    }

    private static Set getAllInterfaces(Class clazz) {
        LinkedHashSet<Class> allInterfaces = new LinkedHashSet<Class>();
        LinkedList stack = new LinkedList();
        stack.addAll(Arrays.asList(clazz.getInterfaces()));
        while (!stack.isEmpty()) {
            Class intf = (Class)stack.removeFirst();
            if (allInterfaces.contains(intf)) continue;
            allInterfaces.add(intf);
            stack.addAll(Arrays.asList(intf.getInterfaces()));
        }
        return allInterfaces;
    }

    public static Set reduceInterfaces(Set source) {
        Class[] classes = source.toArray(new Class[source.size()]);
        classes = ClassLoadingUtil.reduceInterfaces(classes);
        return new LinkedHashSet<Class>(Arrays.asList(classes));
    }

    public static Class[] reduceInterfaces(Class[] source) {
        source = (Class[])source.clone();
        block0: for (int leftIndex = 0; leftIndex < source.length - 1; ++leftIndex) {
            Class left = source[leftIndex];
            if (left == null) continue;
            for (int rightIndex = leftIndex + 1; rightIndex < source.length; ++rightIndex) {
                Class right = source[rightIndex];
                if (right == null) continue;
                if (left == right || right.isAssignableFrom(left)) {
                    source[rightIndex] = null;
                    continue;
                }
                if (!left.isAssignableFrom(right)) continue;
                source[leftIndex] = null;
                continue block0;
            }
        }
        Class clazz = null;
        for (int i = 0; i < source.length; ++i) {
            if (source[i] == null || source[i].isInterface()) continue;
            if (clazz != null) {
                throw new IllegalArgumentException("Source contains two classes which are not subclasses of each other: " + clazz.getName() + ", " + source[i].getName());
            }
            clazz = source[i];
            source[i] = null;
        }
        ArrayList<Class> list = new ArrayList<Class>(source.length);
        if (clazz != null) {
            list.add(clazz);
        }
        for (int i = 0; i < source.length; ++i) {
            if (source[i] == null) continue;
            list.add(source[i]);
        }
        return list.toArray(new Class[list.size()]);
    }

    static {
        PRIMITIVE_CLASS_MAP.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASS_MAP.put("Z", Boolean.TYPE);
        PRIMITIVE_CLASS_MAP.put("byte", Byte.TYPE);
        PRIMITIVE_CLASS_MAP.put("B", Byte.TYPE);
        PRIMITIVE_CLASS_MAP.put("char", Character.TYPE);
        PRIMITIVE_CLASS_MAP.put("C", Character.TYPE);
        PRIMITIVE_CLASS_MAP.put("short", Short.TYPE);
        PRIMITIVE_CLASS_MAP.put("S", Short.TYPE);
        PRIMITIVE_CLASS_MAP.put("int", Integer.TYPE);
        PRIMITIVE_CLASS_MAP.put("I", Integer.TYPE);
        PRIMITIVE_CLASS_MAP.put("long", Long.TYPE);
        PRIMITIVE_CLASS_MAP.put("J", Long.TYPE);
        PRIMITIVE_CLASS_MAP.put("float", Float.TYPE);
        PRIMITIVE_CLASS_MAP.put("F", Float.TYPE);
        PRIMITIVE_CLASS_MAP.put("double", Double.TYPE);
        PRIMITIVE_CLASS_MAP.put("D", Double.TYPE);
        PRIMITIVE_CLASS_MAP.put("void", Void.TYPE);
        PRIMITIVE_CLASS_MAP.put("V", Void.TYPE);
        CLASS_TO_SIGNATURE_MAP.put(Boolean.TYPE, "Z");
        CLASS_TO_SIGNATURE_MAP.put(Byte.TYPE, "B");
        CLASS_TO_SIGNATURE_MAP.put(Character.TYPE, "C");
        CLASS_TO_SIGNATURE_MAP.put(Short.TYPE, "S");
        CLASS_TO_SIGNATURE_MAP.put(Integer.TYPE, "I");
        CLASS_TO_SIGNATURE_MAP.put(Long.TYPE, "J");
        CLASS_TO_SIGNATURE_MAP.put(Float.TYPE, "F");
        CLASS_TO_SIGNATURE_MAP.put(Double.TYPE, "D");
        CLASS_TO_SIGNATURE_MAP.put(Void.TYPE, "V");
    }
}

