/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.corba;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.rmi.CORBA.Stub;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.FixedValue;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.NoOp;
import org.apache.tuscany.sca.binding.ejb.corba.Java2IDLUtil;
import org.apache.tuscany.sca.binding.ejb.corba.StubMethodInterceptor;

public class DynamicStubClassLoader
extends ClassLoader {
    private static final String PACKAGE_PREFIX = "org.omg.stub.";
    private static final CallbackFilter FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if (!Modifier.isPublic(method.getModifiers())) {
                return 0;
            }
            if (method.getReturnType().equals(String[].class) && method.getParameterTypes().length == 0 && method.getName().equals("_ids")) {
                return 2;
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                return 1;
            }
            return 0;
        }
    };

    public synchronized Class loadClass(final String name) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (!name.startsWith(PACKAGE_PREFIX)) {
                throw new ClassNotFoundException("Could not load class: " + name);
            }
            Class iface = this.loadStubInterfaceClass(name, classLoader);
            try {
                Enhancer enhancer = new Enhancer();
                enhancer.setSuperclass(Stub.class);
                enhancer.setInterfaces(new Class[]{iface});
                enhancer.setCallbackFilter(FILTER);
                enhancer.setCallbackTypes(new Class[]{NoOp.class, MethodInterceptor.class, FixedValue.class});
                enhancer.setUseFactory(false);
                enhancer.setClassLoader(classLoader);
                enhancer.setNamingPolicy(new NamingPolicy(){

                    public String getClassName(String s, String s1, Object o, Predicate predicate) {
                        return name;
                    }
                });
                Class result = enhancer.createClass();
                assert (result != null);
                StubMethodInterceptor interceptor = new StubMethodInterceptor(iface);
                Ids ids = new Ids(iface);
                Enhancer.registerStaticCallbacks((Class)result, (Callback[])new Callback[]{NoOp.INSTANCE, interceptor, ids});
                return result;
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Error e3) {
                throw e3;
            }
        }
    }

    private Class loadStubInterfaceClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            int begin = name.lastIndexOf(46) + 1;
            String iPackage = name.substring(13, begin);
            String iName = iPackage + name.substring(begin + 1, name.length() - 5);
            return classLoader.loadClass(iName);
        }
        catch (ClassNotFoundException e) {
            StackTraceElement stackTraceElement;
            StackTraceElement[] stackTrace = e.getStackTrace();
            for (int i = 0; !(i >= stackTrace.length || (stackTraceElement = stackTrace[i]).getClassName().equals("org.omg.CosNaming.NamingContextExtPOA") && stackTraceElement.getMethodName().equals("_invoke")); ++i) {
            }
            throw new ClassNotFoundException("Unable to generate stub", e);
        }
    }

    private static final class Ids
    implements FixedValue {
        private final String[] typeIds;

        public Ids(Class type) {
            this.typeIds = Java2IDLUtil.createCorbaIds(type);
        }

        public Object loadObject() throws Exception {
            return this.typeIds;
        }
    }
}

