/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.corba;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.ejb.EJBObject;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.tuscany.sca.binding.ejb.corba.Java2IDLUtil;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class StubMethodInterceptor
implements MethodInterceptor {
    private static final Method ISIDENTICAL;
    private final Class type;
    private final Map operations;

    public StubMethodInterceptor(Class type) {
        this.type = type;
        this.operations = Collections.unmodifiableMap(Java2IDLUtil.mapMethodToOperation(type));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.lang.Object intercept(java.lang.Object proxy, Method method, java.lang.Object[] args, MethodProxy methodProxy) throws Throwable {
        ServantObject servantObject;
        Stub stub = (Stub)proxy;
        if (method.equals(ISIDENTICAL)) {
            Object otherObject = (Object)args[0];
            return new Boolean(stub._is_equivalent(otherObject));
        }
        String operationName = (String)this.operations.get(method);
        if (operationName == null) {
            throw new IllegalStateException("Unknown method: " + method);
        }
        while (true) {
            if (!Util.isLocal((Stub)stub)) {
                InputStream in = null;
                try {
                    java.lang.Object result;
                    java.lang.Object parameterType;
                    OutputStream out = (OutputStream)stub._request(operationName, true);
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        parameterType = parameterTypes[i];
                        Java2IDLUtil.writeObject(parameterType, args[i], out);
                    }
                    in = (InputStream)stub._invoke((org.omg.CORBA.portable.OutputStream)out);
                    parameterType = result = Java2IDLUtil.readObject(method.getReturnType(), in);
                    stub._releaseReply((org.omg.CORBA.portable.InputStream)in);
                    return parameterType;
                }
                catch (RemarshalException exception) {
                    stub._releaseReply(in);
                    catch (ApplicationException exception2) {
                        Java2IDLUtil.throwException(method, (InputStream)exception2.getInputStream());
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        catch (SystemException e) {
                            throw Util.mapSystemException((SystemException)e);
                        }
                    }
                }
                finally {
                    stub._releaseReply(in);
                }
                continue;
            }
            servantObject = stub._servant_preinvoke(operationName, this.type);
            if (servantObject != null) break;
        }
        try {
            java.lang.Object[] argsCopy = Util.copyObjects((java.lang.Object[])args, (ORB)stub._orb());
            java.lang.Object result = null;
            try {
                result = method.invoke(servantObject.servant, argsCopy);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() == null) throw e;
                throw e.getCause();
            }
            java.lang.Object e = result = Util.copyObject((java.lang.Object)result, (ORB)stub._orb());
            return e;
        }
        catch (Throwable throwable) {
            Throwable throwableCopy = (Throwable)Util.copyObject((java.lang.Object)throwable, (ORB)stub._orb());
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            int i = 0;
            while (i < exceptionTypes.length) {
                Class<?> exceptionType = exceptionTypes[i];
                if (exceptionType.isInstance(throwableCopy)) {
                    throw throwableCopy;
                }
                ++i;
            }
            throw Util.wrapException((Throwable)throwableCopy);
        }
        finally {
            stub._servant_postinvoke(servantObject);
        }
    }

    static {
        try {
            ISIDENTICAL = EJBObject.class.getMethod("isIdentical", EJBObject.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

