/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.binding.ejb.EJBBinding;
import org.apache.tuscany.sca.binding.ejb.impl.EJBBindingImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBBindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<EJBBindingImpl> {
    private PolicyFactory policyFactory;
    private ExtensionFactory extensionFactory;
    private PolicyAttachPointProcessor policyProcessor;
    private StAXAttributeProcessor<Object> extensionAttributeProcessor;
    private Monitor monitor;

    public EJBBindingProcessor(ExtensionPointRegistry extensionPoints) {
        ModelFactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.extensionFactory = modelFactories.getFactory(ExtensionFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        XMLInputFactory inputFactory = modelFactories.getFactory(XMLInputFactory.class);
        XMLOutputFactory outputFactory = modelFactories.getFactory(XMLOutputFactory.class);
        StAXAttributeProcessorExtensionPoint attributeExtensionPoint = extensionPoints.getExtensionPoint(StAXAttributeProcessorExtensionPoint.class);
        this.extensionAttributeProcessor = new ExtensibleStAXAttributeProcessor(attributeExtensionPoint, inputFactory, outputFactory, this.monitor);
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = utilities.getUtility(MonitorFactory.class);
        if (monitorFactory != null) {
            this.monitor = monitorFactory.createMonitor();
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "binding-ejb-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return EJBBinding.BINDING_EJB_QNAME;
    }

    @Override
    public EJBBindingImpl read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String requires;
        String ejbVersion;
        String sessionType;
        String ejbLinkName;
        String homeInterface;
        String uri;
        EJBBindingImpl ejbBinding = new EJBBindingImpl();
        this.policyProcessor.readPolicies(ejbBinding, reader);
        String name = reader.getAttributeValue(null, "name");
        if (name != null) {
            ejbBinding.setName(name);
        }
        if ((uri = EJBBindingProcessor.getURIString(reader, "uri")) != null) {
            ejbBinding.setURI(uri);
        }
        if ((homeInterface = reader.getAttributeValue(null, "homeInterface")) != null) {
            ejbBinding.setHomeInterface(homeInterface);
        }
        if ((ejbLinkName = reader.getAttributeValue(null, "ejb-link-name")) != null) {
            ejbBinding.setEjbLinkName(ejbLinkName);
        }
        if ((sessionType = reader.getAttributeValue(null, "session-type")) != null) {
            if (sessionType.equals("stateless")) {
                ejbBinding.setSessionType(EJBBinding.SessionType.STATELESS);
            } else if (sessionType.equals("stateful")) {
                ejbBinding.setSessionType(EJBBinding.SessionType.STATEFUL);
            } else {
                this.error("UnknownEJBSessionType", reader, sessionType, name);
            }
        }
        if ((ejbVersion = reader.getAttributeValue(null, "ejb-version")) != null) {
            if (ejbVersion.equals("EJB2")) {
                ejbBinding.setEjbVersion(EJBBinding.EJBVersion.EJB2);
            } else if (ejbVersion.equals("EJB3")) {
                ejbBinding.setEjbVersion(EJBBinding.EJBVersion.EJB3);
            } else {
                this.error("UnknownEJBVersion", reader, ejbVersion, name);
            }
        }
        if ((requires = reader.getAttributeValue(null, "requires")) != null) {
            ejbBinding.setRequires(requires);
        }
        QName elementName = reader.getName();
        for (int a = 0; a < reader.getAttributeCount(); ++a) {
            QName attributeName = reader.getAttributeName(a);
            if (attributeName.getNamespaceURI() == null || attributeName.getNamespaceURI().length() <= 0 || elementName.getNamespaceURI().equals(attributeName.getNamespaceURI())) continue;
            Object attributeValue = this.extensionAttributeProcessor.read(attributeName, reader);
            Extension attributeExtension = attributeValue instanceof Extension ? (Extension)attributeValue : this.extensionFactory.createExtension(attributeName, attributeValue, true);
            ejbBinding.getAttributeExtensions().add(attributeExtension);
        }
        return ejbBinding;
    }

    @Override
    public void write(EJBBindingImpl ejbBinding, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "binding.ejb");
        if (ejbBinding.getName() != null) {
            writer.writeAttribute("name", ejbBinding.getName());
        }
        if (ejbBinding.getURI() != null) {
            writer.writeAttribute("uri", ejbBinding.getURI());
        }
        for (Extension extension : ejbBinding.getAttributeExtensions()) {
            if (!extension.isAttribute()) continue;
            this.extensionAttributeProcessor.write(extension, writer);
        }
        writer.writeEndElement();
    }

    @Override
    public Class<EJBBindingImpl> getModelType() {
        return EJBBindingImpl.class;
    }

    @Override
    public void resolve(EJBBindingImpl ejbBinding, ModelResolver modelResolver) throws ContributionResolveException {
    }
}

