/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.util;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;

class EJBLocator {
    public static final String SERVER_ROOT = "NameServiceServerRoot";
    public static final String CELL_PERSISTENT_ROOT = "NameServiceCellPersistentRoot";
    public static final String CELL_ROOT = "NameServiceCellRoot";
    public static final String NODE_ROOT = "NameServiceNodeRoot";
    public static final String DEFAULT_ROOT = "NameService";
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_NAMING_PORT = 2809;
    public static final String NAMING_SERVICE = "NameService";
    private static final Set<String> ROOTS = new HashSet<String>(Arrays.asList("NameServiceServerRoot", "NameServiceCellPersistentRoot", "NameServiceCellRoot", "NameService", "NameServiceNodeRoot"));
    private static final String RFC2396 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789;/:?@&=+$,-_.!~*'()";
    private static final String HEX = "0123456789ABCDEF";
    private String hostName = "127.0.0.1";
    private int port = 2809;
    private String root = "NameServiceServerRoot";
    private ORB orb = null;
    private ObjectLocator locator = null;
    private boolean managed = true;

    EJBLocator(boolean managed) {
        this.managed = managed;
        if (!managed) {
            String url = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.naming.provider.url");
                }
            });
            this.processCorbaURL(url);
        }
    }

    EJBLocator(String hostName, int port) {
        this.hostName = hostName == null ? DEFAULT_HOST : hostName;
        this.port = port > 0 ? port : 2809;
        this.root = SERVER_ROOT;
    }

    EJBLocator(String hostName, int port, String root) {
        this(hostName, port);
        if (!ROOTS.contains(root)) {
            throw new IllegalArgumentException(root + " is not a legal root");
        }
        this.root = root;
    }

    EJBLocator(String corbaName, boolean managed) {
        this.managed = managed;
        if (!corbaName.startsWith("corbaname:iiop:")) {
            throw new IllegalArgumentException(corbaName + " is not a legal corbaname");
        }
        this.processCorbaURL(corbaName);
    }

    private void processCorbaURL(String url) {
        if (url != null && (url.startsWith("corbaname:iiop:") || url.startsWith("corbaloc:iiop:"))) {
            String[] parts = url.split("(:|/|#)");
            if (parts.length > 2 && parts[2].length() > 0) {
                this.hostName = parts[2];
                int index = this.hostName.lastIndexOf(64);
                if (index != -1) {
                    this.hostName = this.hostName.substring(index + 1);
                }
            }
            if (parts.length > 3 && parts[3].length() > 0) {
                this.port = Integer.parseInt(parts[3]);
            }
            if (parts.length > 4 && parts[4].length() > 0) {
                this.root = parts[4];
            }
        }
    }

    private static String getCorbaname(String hostName, int port, String root, String name) {
        if (name == null) {
            return "corbaname:iiop:" + hostName + ":" + port + "/" + root;
        }
        return "corbaname:iiop:" + hostName + ":" + port + "/" + root + "#" + EJBLocator.toCorbaname(name);
    }

    String getCorbaname(String name) {
        return EJBLocator.getCorbaname(this.hostName, this.port, this.root, name);
    }

    public ORB connect() {
        if (this.orb == null) {
            Properties props = new Properties();
            this.orb = ORB.init((String[])null, (Properties)props);
        }
        return this.orb;
    }

    private static String replace(String source, String match, String replace) {
        int index = source.indexOf(match, 0);
        if (index >= 0) {
            StringBuffer result = new StringBuffer(source.length() + 16);
            int matchLength = match.length();
            int startIndex = 0;
            while (index >= 0) {
                result.append(source.substring(startIndex, index));
                result.append(replace);
                startIndex = index + matchLength;
                index = source.indexOf(match, startIndex);
            }
            if (startIndex < source.length()) {
                result.append(source.substring(startIndex));
            }
            return result.toString();
        }
        return source;
    }

    private static Object resovleString(NamingContextExt initCtx, String jndiName) throws NamingException {
        try {
            String name = EJBLocator.stringify(jndiName);
            return initCtx.resolve_str(name);
        }
        catch (Exception e) {
            NamingException ne = new NamingException(e.getMessage());
            ne.setRootCause(e);
            throw ne;
        }
    }

    Object stringToObject(String jndiName) throws NamingException {
        String corbaName = null;
        corbaName = jndiName.startsWith("corbaloc:") || jndiName.startsWith("corbaname:") ? jndiName : this.getCorbaname(jndiName);
        this.connect();
        Object obj = this.orb.string_to_object(corbaName);
        return obj;
    }

    private boolean isJndiConfigured() {
        if (this.managed) {
            return true;
        }
        Boolean provided = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String initCtxFactory = System.getProperty("java.naming.factory.initial");
                if (initCtxFactory == null) {
                    URL file = Thread.currentThread().getContextClassLoader().getResource("jndi.properties");
                    if (file != null) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return provided;
    }

    static String encode2396(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer encoded = new StringBuffer(s);
        for (int i = 0; i < encoded.length(); ++i) {
            char c = encoded.charAt(i);
            if (RFC2396.indexOf(c) != -1) continue;
            encoded.setCharAt(i, '%');
            char[] ac = Integer.toHexString(c).toCharArray();
            if (ac.length == 2) {
                encoded.insert(i + 1, ac);
            } else if (ac.length == 1) {
                encoded.insert(i + 1, '0');
                encoded.insert(i + 2, ac[0]);
            } else {
                throw new IllegalArgumentException("Invalid character '" + c + "' in \"" + s + "\"");
            }
            i += 2;
        }
        return encoded.toString();
    }

    static String decode2396(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer decoded = new StringBuffer(s);
        for (int i = 0; i < decoded.length(); ++i) {
            char c = decoded.charAt(i);
            if (c == '%') {
                if (i + 2 >= decoded.length()) {
                    throw new IllegalArgumentException("Incomplete key_string escape sequence");
                }
                int j = HEX.indexOf(decoded.charAt(i + 1)) * 16 + HEX.indexOf(decoded.charAt(i + 2));
                decoded.setCharAt(i, (char)j);
                decoded.delete(i + 1, i + 3);
                continue;
            }
            if (RFC2396.indexOf(c) != -1) continue;
            throw new IllegalArgumentException("Invalid key_string character '" + c + "'");
        }
        return decoded.toString();
    }

    private static String stringify(String jndiName) {
        return EJBLocator.replace(EJBLocator.encode2396(jndiName), ".", "\\.");
    }

    private static String toCorbaname(String jndiName) {
        return EJBLocator.replace(EJBLocator.encode2396(jndiName), ".", "%5C%2E");
    }

    private ObjectLocator getObjectLocator() throws NamingException {
        if (this.locator != null) {
            return this.locator;
        }
        this.locator = this.isJndiConfigured() ? new JndiLocator() : new CosNamingLocator();
        return this.locator;
    }

    public java.lang.Object locate(String jndiName) throws NamingException {
        java.lang.Object result = this.getObjectLocator().locate(jndiName);
        return result;
    }

    public void setHostEnv(boolean managed) {
        this.managed = managed;
    }

    private final class CosNamingLocator
    implements ObjectLocator {
        private NamingContextExt context;

        private CosNamingLocator() {
        }

        public java.lang.Object locate(String name) throws NamingException {
            if (this.context != null) {
                return EJBLocator.resovleString(this.context, name);
            }
            return EJBLocator.this.stringToObject(name);
        }
    }

    private final class JndiLocator
    implements ObjectLocator {
        private Context context = new InitialContext();

        private JndiLocator() throws NamingException {
        }

        public java.lang.Object locate(String name) throws NamingException {
            return this.context.lookup(name);
        }
    }

    private static interface ObjectLocator {
        public java.lang.Object locate(String var1) throws NamingException;
    }
}

