/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.osoa.sca.ServiceRuntimeException;

final class JavaReflectionAdapter {
    private static Map<Class, JavaReflectionAdapter> adapters = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class, Object> DEFAULT_VALUES = new HashMap<Class, Object>();
    private Map<String, Method> methodMap = new HashMap<String, Method>();

    private JavaReflectionAdapter(final Class clazz) {
        Method[] methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getMethods();
            }
        });
        for (int i = 0; i < methods.length; ++i) {
            this.methodMap.put(methods[i].getName(), methods[i]);
        }
    }

    static synchronized JavaReflectionAdapter createJavaReflectionAdapter(Class clazz) {
        JavaReflectionAdapter adapter = adapters.get(clazz);
        if (adapter == null) {
            adapter = new JavaReflectionAdapter(clazz);
            adapters.put(clazz, adapter);
        }
        return adapter;
    }

    Method getMethod(String methodName) throws NoSuchMethodException {
        Method method = this.methodMap.get(methodName);
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        return method;
    }

    Map getMethods() {
        return this.methodMap;
    }

    Object invoke(Method method, Object object, Object[] args) throws InvocationTargetException, IllegalAccessException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (args[i] != null || !parameterType.isPrimitive()) continue;
            args[i] = DEFAULT_VALUES.get(parameterType);
        }
        return method.invoke(object, args);
    }

    boolean setProperty(Object bean, String propertyName, Object value) {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(propertyName, bean.getClass());
            Method writeMethod = propertyDescriptor.getWriteMethod();
            writeMethod.invoke(bean, value);
            return true;
        }
        catch (InvocationTargetException e) {
            throw new ServiceRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        DEFAULT_VALUES.put(Boolean.TYPE, Boolean.FALSE);
        DEFAULT_VALUES.put(Byte.TYPE, new Byte(0));
        DEFAULT_VALUES.put(Character.TYPE, new Character('\u0000'));
        DEFAULT_VALUES.put(Short.TYPE, new Short(0));
        DEFAULT_VALUES.put(Integer.TYPE, 0);
        DEFAULT_VALUES.put(Long.TYPE, new Long(0L));
        DEFAULT_VALUES.put(Float.TYPE, new Float(0.0));
        DEFAULT_VALUES.put(Double.TYPE, new Double(0.0));
    }
}

