/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.erlang.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.binding.erlang.ErlangBinding;
import org.apache.tuscany.sca.binding.erlang.impl.ErlangBindingImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErlangBindingProcessor
implements StAXArtifactProcessor<ErlangBinding> {
    private PolicyFactory policyFactory;
    private PolicyAttachPointProcessor policyProcessor;
    private static final String ATTR_COOKIE = "cookie";
    private static final String ATTR_MBOX = "mbox";
    private static final String ATTR_MODULE = "module";
    private static final String ATTR_NODE = "node";
    private static final String ATTR_SERVICE_THREAD_POOL = "serviceThreadPool";
    private static final String ATTR_TIMEOUT = "timeout";

    public ErlangBindingProcessor(ModelFactoryExtensionPoint modelFactories) {
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
    }

    @Override
    public QName getArtifactType() {
        return ErlangBinding.BINDING_ERLANG_QNAME;
    }

    @Override
    public ErlangBinding read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        ErlangBindingImpl binding = new ErlangBindingImpl();
        this.policyProcessor.readPolicies(binding, reader);
        binding.setNode(reader.getAttributeValue(null, ATTR_NODE));
        String mboxValue = reader.getAttributeValue(null, ATTR_MBOX);
        if (mboxValue != null && mboxValue.length() > 0) {
            try {
                binding.setMbox(Boolean.parseBoolean(mboxValue));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            binding.setTimeout(Long.parseLong(reader.getAttributeValue(null, ATTR_TIMEOUT)));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        binding.setModule(reader.getAttributeValue(null, ATTR_MODULE));
        binding.setCookie(reader.getAttributeValue(null, ATTR_COOKIE));
        try {
            binding.setServiceThreadPool(Integer.parseInt(reader.getAttributeValue(null, ATTR_SERVICE_THREAD_POOL)));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return binding;
    }

    @Override
    public void write(ErlangBinding model, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.0", "binding.erlang");
        if (model.getCookie() != null && model.getCookie().length() > 0) {
            writer.writeAttribute(ATTR_COOKIE, model.getCookie());
        }
        if (model.isMbox()) {
            writer.writeAttribute(ATTR_MBOX, Boolean.TRUE.toString());
        }
        if (model.getModule() != null && model.getModule().length() > 0) {
            writer.writeAttribute(ATTR_MODULE, model.getModule());
        }
        if (model.getNode() != null && model.getNode().length() > 0) {
            writer.writeAttribute(ATTR_NODE, model.getNode());
        }
        if (!model.isDefaultServiceThreadPool()) {
            writer.writeAttribute(ATTR_SERVICE_THREAD_POOL, Integer.toString(model.getServiceThreadPool()));
        }
        if (!model.isDefaultTimeout()) {
            writer.writeAttribute(ATTR_TIMEOUT, Long.toString(model.getTimeout()));
        }
        writer.writeEndElement();
    }

    @Override
    public Class<ErlangBinding> getModelType() {
        return ErlangBinding.class;
    }

    @Override
    public void resolve(ErlangBinding model, ModelResolver resolver) throws ContributionResolveException {
    }
}

