/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.erlang.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.binding.erlang.ErlangBinding;
import org.apache.tuscany.sca.binding.erlang.impl.ErlangReferenceBindingProvider;
import org.apache.tuscany.sca.binding.erlang.impl.ErlangServiceBindingProvider;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErlangBindingProviderFactory
implements BindingProviderFactory<ErlangBinding> {
    private static final Logger logger = Logger.getLogger(ErlangBindingProviderFactory.class.getName());
    private Set<String> nodes = new HashSet<String>();

    public ErlangBindingProviderFactory(ExtensionPointRegistry registry) {
    }

    @Override
    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, ErlangBinding binding) {
        return new ErlangReferenceBindingProvider(binding, reference);
    }

    @Override
    public ServiceBindingProvider createServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, ErlangBinding binding) {
        ErlangServiceBindingProvider provider = null;
        try {
            if (this.nodes.contains(binding.getNode())) {
                logger.log(Level.WARNING, "Node name '" + binding.getNode() + "' already registered. This service will not be spawned.");
            } else {
                provider = new ErlangServiceBindingProvider(binding, service);
                this.nodes.add(binding.getNode());
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception during creating ServiceBindingProvider", e);
        }
        return provider;
    }

    @Override
    public Class<ErlangBinding> getModelType() {
        return ErlangBinding.class;
    }
}

