/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.erlang.impl;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpConnection;
import com.ericsson.otp.erlang.OtpEpmd;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpMbox;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpNode;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpSelf;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.binding.erlang.ErlangBinding;
import org.apache.tuscany.sca.binding.erlang.impl.MessageHelper;
import org.apache.tuscany.sca.binding.erlang.impl.exceptions.ErlangException;
import org.apache.tuscany.sca.binding.erlang.impl.types.TypeHelpersProxy;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;

public class ErlangInvoker
implements Invoker {
    private static final Logger logger = Logger.getLogger(ErlangInvoker.class.getName());
    private ErlangBinding binding;

    public ErlangInvoker(ErlangBinding binding) {
        this.binding = binding;
    }

    private void reportProblem(Message msg, Exception e) {
        if (msg.getOperation().getFaultTypes().size() > 0) {
            msg.setFaultBody(e);
        } else {
            msg.setBody(null);
            logger.log(Level.WARNING, "Problem while sending/receiving data", e);
        }
    }

    private String getClientNodeName() {
        return "_connector_to_" + this.binding.getNode() + System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message sendMessage(Message msg) {
        OtpMbox tmpMbox = null;
        OtpNode node = null;
        try {
            node = new OtpNode(this.getClientNodeName());
            if (this.binding.hasCookie()) {
                node.setCookie(this.binding.getCookie());
            }
            tmpMbox = node.createMbox();
            Object[] args = (Object[])(msg.getBody() != null ? msg.getBody() : new Object[]{});
            Method jmethod = ((JavaOperation)msg.getOperation()).getJavaMethod();
            OtpErlangObject[] argsArray = new OtpErlangObject[]{tmpMbox.self(), TypeHelpersProxy.toErlang(args, jmethod.getParameterAnnotations())};
            OtpErlangTuple otpArgs = new OtpErlangTuple(argsArray);
            tmpMbox.send(msg.getOperation().getName(), this.binding.getNode(), (OtpErlangObject)otpArgs);
            if (msg.getOperation().getOutputType() != null) {
                OtpMsg resultMsg = null;
                resultMsg = this.binding.hasTimeout() ? tmpMbox.receiveMsg(this.binding.getTimeout()) : tmpMbox.receiveMsg();
                OtpErlangObject result = resultMsg.getMsg();
                msg.setBody(TypeHelpersProxy.toJava(result, msg.getOperation().getOutputType().getPhysical(), jmethod.getAnnotations()));
            }
        }
        catch (InterruptedException e) {
            ErlangException ee = new ErlangException("Timeout while receiving message reply", e);
            msg.setBody(null);
            this.reportProblem(msg, ee);
        }
        catch (Exception e) {
            this.reportProblem(msg, e);
        }
        finally {
            if (tmpMbox != null) {
                tmpMbox.close();
            }
            if (node != null) {
                OtpEpmd.unPublishPort((OtpLocalNode)node);
                node.close();
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message invokeOperation(Message msg) {
        OtpSelf self = null;
        OtpPeer other = null;
        OtpConnection connection = null;
        try {
            self = new OtpSelf(this.getClientNodeName());
            if (this.binding.hasCookie()) {
                self.setCookie(this.binding.getCookie());
            }
            other = new OtpPeer(this.binding.getNode());
            connection = self.connect(other);
            Method jmethod = ((JavaOperation)msg.getOperation()).getJavaMethod();
            OtpErlangList params = TypeHelpersProxy.toErlangAsList(msg.getBody(), jmethod.getParameterAnnotations());
            OtpErlangTuple message = MessageHelper.rpcMessage(self.pid(), self.createRef(), this.binding.getModule(), msg.getOperation().getName(), params);
            connection.send(MessageHelper.RPC_MBOX, (OtpErlangObject)message);
            OtpErlangObject rpcResponse = null;
            rpcResponse = this.binding.hasTimeout() ? connection.receive(this.binding.getTimeout()) : connection.receive();
            OtpErlangObject result = ((OtpErlangTuple)rpcResponse).elementAt(1);
            if (MessageHelper.isfunctionUndefMessage(result)) {
                ErlangException e = new ErlangException("No '" + this.binding.getModule() + ":" + msg.getOperation().getName() + "' operation defined on remote '" + this.binding.getNode() + "' node.");
                this.reportProblem(msg, e);
                msg.setBody(null);
            } else if (msg.getOperation().getOutputType() != null) {
                jmethod.getAnnotations();
                msg.setBody(TypeHelpersProxy.toJava(result, msg.getOperation().getOutputType().getPhysical(), jmethod.getAnnotations()));
            }
        }
        catch (OtpAuthException e) {
            ErlangException ee = new ErlangException("Problem while authenticating client - check your cookie", e);
            msg.setBody(null);
            this.reportProblem(msg, ee);
        }
        catch (InterruptedException e) {
            ErlangException ee = new ErlangException("Timeout while receiving RPC reply", e);
            msg.setBody(null);
            this.reportProblem(msg, ee);
        }
        catch (Exception e) {
            this.reportProblem(msg, e);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return msg;
    }

    public Message invoke(Message msg) {
        if (this.binding.isMbox()) {
            return this.sendMessage(msg);
        }
        return this.invokeOperation(msg);
    }
}

