/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.erlang.impl;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpConnection;
import com.ericsson.otp.erlang.OtpSelf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.binding.erlang.ErlangBinding;
import org.apache.tuscany.sca.binding.erlang.impl.ErlangNodeElement;
import org.apache.tuscany.sca.binding.erlang.impl.ServiceExecutor;
import org.apache.tuscany.sca.binding.erlang.impl.exceptions.ErlangException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class ErlangNode
implements Runnable {
    private static final Logger logger = Logger.getLogger(ErlangNode.class.getName());
    private ErlangNodeElement nodeElement;
    private String name;
    private OtpSelf self;
    private ExecutorService executors;
    private boolean stopRequested;
    private Map<String, List<Operation>> groupedOperations;

    public ErlangNode(String name, ErlangBinding binding, RuntimeComponentService service) throws Exception {
        this.name = name;
        this.self = new OtpSelf(name);
        boolean registered = this.self.publishPort();
        if (!registered) {
            throw new ErlangException("Problem with publishing service under epmd server.");
        }
        if (binding.hasCookie()) {
            this.self.setCookie(binding.getCookie());
        }
        this.registerBinding(binding, service);
    }

    public void stop() {
        this.stopRequested = true;
        this.executors.shutdownNow();
    }

    public void run() {
        this.executors = Executors.newFixedThreadPool(this.nodeElement.getBinding().getServiceThreadPool());
        while (!this.stopRequested) {
            try {
                OtpConnection connection = this.self.accept();
                this.executors.execute(new ServiceExecutor(connection, this.groupedOperations, this.nodeElement, this.name));
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error occured while accepting connection on '" + this.name + "' node", e);
            }
            catch (OtpAuthException e) {
                logger.log(Level.WARNING, "Error while authenticating client", e);
            }
        }
        this.executors.shutdownNow();
    }

    private void registerBinding(ErlangBinding binding, RuntimeComponentService service) throws ErlangException {
        if (binding.isMbox()) {
            List<Operation> operations = service.getInterfaceContract().getInterface().getOperations();
            this.groupedOperations = new HashMap<String, List<Operation>>();
            for (Operation operation : operations) {
                List<Operation> operationsGroup = this.groupedOperations.get(operation.getName());
                if (operationsGroup == null) {
                    operationsGroup = new ArrayList<Operation>();
                    this.groupedOperations.put(operation.getName(), operationsGroup);
                }
                operationsGroup.add(operation);
            }
        }
        this.nodeElement = new ErlangNodeElement();
        this.nodeElement.setService(service);
        this.nodeElement.setBinding(binding);
    }
}

