/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.erlang.impl;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpConnection;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangRef;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpMsg;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.binding.erlang.ErlangBinding;
import org.apache.tuscany.sca.binding.erlang.impl.ErlangNodeElement;
import org.apache.tuscany.sca.binding.erlang.impl.MessageHelper;
import org.apache.tuscany.sca.binding.erlang.impl.TypeMismatchException;
import org.apache.tuscany.sca.binding.erlang.impl.types.TypeHelpersProxy;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceExecutor
implements Runnable {
    private static final Logger logger = Logger.getLogger(ServiceExecutor.class.getName());
    private ErlangNodeElement nodeElement;
    private OtpConnection connection;
    private Map<String, List<Operation>> groupedOperations;
    private String name;

    public ServiceExecutor(OtpConnection connection, Map<String, List<Operation>> groupedOperations, ErlangNodeElement nodeElement, String name) {
        this.connection = connection;
        this.groupedOperations = groupedOperations;
        this.nodeElement = nodeElement;
        this.name = name;
    }

    private void sendMessage(OtpConnection connection, OtpErlangPid pid, OtpErlangRef ref, OtpErlangAtom head, OtpErlangObject message) throws IOException {
        Object tResult = null;
        tResult = head != null ? new OtpErlangTuple(new OtpErlangObject[]{head, message}) : message;
        OtpErlangTuple msg = null;
        msg = new OtpErlangTuple(new OtpErlangObject[]{ref, tResult});
        connection.send(pid, (OtpErlangObject)msg);
    }

    private void handleRpc(OtpMsg msg) {
        block18: {
            OtpErlangTuple request = null;
            OtpErlangPid senderPid = null;
            OtpErlangRef senderRef = null;
            try {
                OtpErlangTuple call = (OtpErlangTuple)msg.getMsg();
                OtpErlangTuple from = (OtpErlangTuple)call.elementAt(1);
                request = (OtpErlangTuple)call.elementAt(2);
                senderPid = (OtpErlangPid)from.elementAt(0);
                senderRef = (OtpErlangRef)from.elementAt(1);
                String module = ((OtpErlangAtom)request.elementAt(1)).atomValue();
                String function = ((OtpErlangAtom)request.elementAt(2)).atomValue();
                OtpErlangObject args = request.elementAt(3);
                OtpErlangList argsList = null;
                argsList = args instanceof OtpErlangList ? (OtpErlangList)args : new OtpErlangList(args);
                if (!this.nodeElement.getBinding().getModule().equals(module)) {
                    OtpErlangObject errorMsg = MessageHelper.functionUndefMessage(module, function, argsList, "Module not found in SCA component.");
                    this.sendMessage(this.connection, senderPid, senderRef, MessageHelper.ATOM_BADRPC, errorMsg);
                    break block18;
                }
                RuntimeComponentService service = this.nodeElement.getService();
                ErlangBinding binding = this.nodeElement.getBinding();
                List<Operation> operations = service.getInterfaceContract().getInterface().getOperations();
                Operation operation = null;
                for (Operation o : operations) {
                    if (!o.getName().equals(function)) continue;
                    operation = o;
                    break;
                }
                if (operation != null) {
                    List<DataType> iTypes = operation.getInputType().getLogical();
                    Class[] forClasses = new Class[iTypes.size()];
                    for (int i = 0; i < iTypes.size(); ++i) {
                        forClasses[i] = iTypes.get(i).getPhysical();
                    }
                    try {
                        Method jmethod = ((JavaOperation)operation).getJavaMethod();
                        Object result = service.getRuntimeWire(binding, service.getInterfaceContract()).invoke(operation, TypeHelpersProxy.toJavaFromList(argsList, forClasses, jmethod.getParameterAnnotations()));
                        OtpErlangObject response = null;
                        if (operation.getOutputType() != null && operation.getOutputType().getPhysical().isArray()) {
                            response = TypeHelpersProxy.toErlangAsResultList(result, jmethod.getAnnotations());
                        } else if (operation.getOutputType() == null) {
                            Object[] arrArg = new Object[]{};
                            response = TypeHelpersProxy.toErlang(arrArg, new Annotation[0][0]);
                        } else {
                            response = TypeHelpersProxy.toErlang(result, jmethod.getAnnotations());
                        }
                        this.sendMessage(this.connection, senderPid, senderRef, null, response);
                        break block18;
                    }
                    catch (Exception e) {
                        if (e.getClass().equals(InvocationTargetException.class) && e.getCause().getClass().equals(IllegalArgumentException.class) || e.getClass().equals(TypeMismatchException.class)) {
                            OtpErlangObject errorMsg = MessageHelper.functionUndefMessage(module, function, argsList, "Operation name found in SCA component, but parameters types didn't match.");
                            this.sendMessage(this.connection, senderPid, senderRef, MessageHelper.ATOM_BADRPC, errorMsg);
                            break block18;
                        }
                        throw e;
                    }
                }
                OtpErlangObject errorMsg = MessageHelper.functionUndefMessage(module, function, argsList, "Operation name not found in SCA component.");
                this.sendMessage(this.connection, senderPid, senderRef, MessageHelper.ATOM_BADRPC, errorMsg);
            }
            catch (ClassCastException e) {
                try {
                    logger.log(Level.WARNING, "On node '" + this.nodeElement.getBinding().getNode() + "' received RPC request which is invalid. Request content is: " + msg.getMsg());
                }
                catch (OtpErlangDecodeException e1) {}
            }
            catch (Exception e) {
                try {
                    this.sendMessage(this.connection, senderPid, senderRef, MessageHelper.ATOM_ERROR, (OtpErlangObject)new OtpErlangString("Unhandled error while processing request: " + e.getClass().getCanonicalName() + ", message: " + e.getMessage()));
                }
                catch (Exception e1) {
                    logger.log(Level.WARNING, "Error during sending error message", e);
                }
            }
        }
    }

    private void handleMsg(OtpMsg msg) {
        block24: {
            Operation matchedOperation = null;
            Object[] args = null;
            OtpErlangPid senderPid = null;
            OtpErlangObject msgNoSender = null;
            List<Operation> operations = this.groupedOperations.get(msg.getRecipientName());
            try {
                if (msg.getMsg().getClass().equals(OtpErlangTuple.class) && ((OtpErlangTuple)msg.getMsg()).elementAt(0).getClass().equals(OtpErlangPid.class)) {
                    senderPid = (OtpErlangPid)((OtpErlangTuple)msg.getMsg()).elementAt(0);
                    msgNoSender = ((OtpErlangTuple)msg.getMsg()).elementAt(1);
                } else {
                    senderPid = msg.getSenderPid();
                    msgNoSender = msg.getMsg();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unexpected error", e);
            }
            if (operations == null) {
                logger.log(Level.WARNING, "Node '" + this.name + "' received message addressed to non exising mbox: " + msg.getRecipientName());
            } else {
                for (Operation operation : operations) {
                    Method method = ((JavaOperation)operation).getJavaMethod();
                    List<DataType> iTypes = operation.getInputType().getLogical();
                    Class[] forClasses = new Class[iTypes.size()];
                    for (int i = 0; i < iTypes.size(); ++i) {
                        forClasses[i] = iTypes.get(i).getPhysical();
                    }
                    try {
                        args = TypeHelpersProxy.toJavaAsArgs(msgNoSender, forClasses, method.getParameterAnnotations());
                        matchedOperation = operation;
                        break;
                    }
                    catch (Exception e) {
                    }
                }
                if (matchedOperation != null) {
                    try {
                        Method jmethod = ((JavaOperation)matchedOperation).getJavaMethod();
                        Object result = this.nodeElement.getService().getRuntimeWire(this.nodeElement.getBinding()).invoke(matchedOperation, args);
                        OtpErlangObject response = null;
                        if (matchedOperation.getOutputType() != null && matchedOperation.getOutputType().getPhysical().isArray()) {
                            response = TypeHelpersProxy.toErlangAsResultList(result, jmethod.getAnnotations());
                        } else if (matchedOperation.getOutputType() != null) {
                            response = TypeHelpersProxy.toErlang(result, jmethod.getAnnotations());
                        }
                        if (response != null && senderPid != null) {
                            this.connection.send(senderPid, response);
                        } else if (response != null && senderPid == null) {
                            logger.log(Level.WARNING, "Cannot send reply - Erlang client didn't provide it's PID and couldn't obtain sender PID from jinterface");
                        }
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() != null && e.getCause().getClass().equals(IllegalArgumentException.class)) {
                            try {
                                this.connection.send(senderPid, (OtpErlangObject)new OtpErlangString("Operation name found in SCA component, but parameters types didn't match."));
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            break block24;
                        }
                        logger.log(Level.WARNING, "Unexpected error", e);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Unexpected error", e);
                    }
                } else {
                    logger.log(Level.WARNING, "No mapping for such arguments in '" + msg.getRecipientName() + "' operation in '" + this.name + "' node. Recevied arguments: " + msgNoSender);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            OtpMsg msg = null;
            msg = this.nodeElement.getBinding().hasTimeout() ? this.connection.receiveMsg(this.nodeElement.getBinding().getTimeout()) : this.connection.receiveMsg();
            if (msg.getRecipientName().equals(MessageHelper.RPC_MBOX) && !this.nodeElement.getBinding().isMbox()) {
                this.handleRpc(msg);
            } else if (!msg.getRecipientName().equals(MessageHelper.RPC_MBOX) && this.nodeElement.getBinding().isMbox()) {
                this.handleMsg(msg);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Problem while receiving message", e);
        }
        catch (OtpErlangExit e) {
        }
        catch (OtpAuthException e) {
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Timeout while waiting for request", e);
        }
        finally {
            this.connection.close();
        }
    }
}

