/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.erlang.impl.types;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.binding.erlang.impl.TypeMismatchException;
import org.apache.tuscany.sca.binding.erlang.impl.types.AnnotatedListTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.AtomTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.BinaryTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.BooleanTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.ByteTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.CharTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.DoubleTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.FloatTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.IntTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.ListTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.LongTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.ShortTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.StringTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.TupleTypeHelper;
import org.apache.tuscany.sca.binding.erlang.impl.types.TypeHelper;
import org.apache.tuscany.sca.binding.erlang.meta.ErlangAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHelpersProxy {
    private static Map<Class<?>, TypeHelper> primitiveTypes = null;

    private static TypeHelper getTypeHelper(Class<?> forClass, Annotation[] notes) {
        TypeHelper typeHelper = null;
        for (int i = 0; i < notes.length; ++i) {
            typeHelper = primitiveTypes.get(notes[i].annotationType());
            if (typeHelper == null) continue;
            Class<?> annotatedType = forClass;
            while (annotatedType.isArray()) {
                annotatedType = annotatedType.getComponentType();
            }
            if (notes[i].annotationType().equals(ErlangAtom.class) && !annotatedType.equals(String.class)) {
                typeHelper = null;
                continue;
            }
            if (!forClass.isArray()) break;
            typeHelper = new AnnotatedListTypeHelper(notes);
            break;
        }
        if (typeHelper == null) {
            typeHelper = primitiveTypes.get(forClass);
        }
        if (typeHelper == null && forClass.isArray()) {
            typeHelper = new ListTypeHelper();
        }
        if (typeHelper == null) {
            typeHelper = new TupleTypeHelper();
        }
        return typeHelper;
    }

    public static OtpErlangObject toErlang(Object object, Annotation[] notes) {
        TypeHelper helper = TypeHelpersProxy.getTypeHelper(object.getClass(), notes);
        return helper.toErlang(object);
    }

    public static OtpErlangObject toErlang(Object[] objects, Annotation[][] notes) {
        OtpErlangList result = null;
        if (objects != null) {
            TypeHelper helper = null;
            switch (objects.length) {
                case 0: {
                    result = new OtpErlangList();
                    break;
                }
                case 1: {
                    helper = TypeHelpersProxy.getTypeHelper(objects[0].getClass(), notes[0]);
                    result = helper.toErlang(objects[0]);
                    break;
                }
                default: {
                    OtpErlangObject[] erlObjects = new OtpErlangObject[objects.length];
                    for (int i = 0; i < objects.length; ++i) {
                        helper = TypeHelpersProxy.getTypeHelper(objects[i].getClass(), notes[i]);
                        erlObjects[i] = helper.toErlang(objects[i]);
                    }
                    result = new OtpErlangTuple(erlObjects);
                }
            }
        }
        return result;
    }

    public static OtpErlangList toErlangAsList(Object array, Annotation[][] notes) {
        return TypeHelpersProxy.toErlangAsList(array, notes, false);
    }

    public static OtpErlangList toErlangAsResultList(Object array, Annotation[] notes) {
        return TypeHelpersProxy.toErlangAsList(array, new Annotation[][]{notes}, true);
    }

    private static OtpErlangList toErlangAsList(Object array, Annotation[][] notes, boolean isArray) {
        OtpErlangList result = null;
        if (array != null) {
            ArrayList<OtpErlangObject> attrsList = new ArrayList<OtpErlangObject>();
            int i = 0;
            try {
                while (true) {
                    Annotation[] currNotes = isArray ? notes[0] : notes[i];
                    TypeHelper helper = TypeHelpersProxy.getTypeHelper(Array.get(array, i).getClass(), currNotes);
                    attrsList.add(helper.toErlang(Array.get(array, i)));
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                result = new OtpErlangList(attrsList.toArray(new OtpErlangObject[attrsList.size()]));
            }
        } else {
            result = new OtpErlangList();
        }
        return result;
    }

    public static Object toJava(OtpErlangObject object, Class<?> forClass, Annotation[] notes) throws Exception {
        try {
            TypeHelper helper = TypeHelpersProxy.getTypeHelper(forClass, notes);
            return helper.toJava(object, forClass);
        }
        catch (ClassCastException e) {
            throw new TypeMismatchException(forClass, object.getClass());
        }
    }

    public static Object[] toJavaFromList(OtpErlangList objects, Class<?>[] forClass, Annotation[][] notes) throws Exception {
        Object[] result;
        block3: {
            result = new Object[objects.arity()];
            try {
                for (int i = 0; i < objects.arity(); ++i) {
                    TypeHelper helper = TypeHelpersProxy.getTypeHelper(forClass[i], notes[i]);
                    result[i] = helper.toJava(objects.elementAt(i), forClass[i]);
                }
            }
            catch (Exception e) {
                if (!e.getClass().equals(ClassCastException.class) && !e.getClass().equals(ArrayIndexOutOfBoundsException.class)) break block3;
                throw new TypeMismatchException();
            }
        }
        return result;
    }

    public static Object[] toJavaAsArgs(OtpErlangObject objects, Class<?>[] forClass, Annotation[][] notes) throws Exception {
        Object[] result;
        block6: {
            OtpErlangObject[] args = null;
            if (objects.getClass().equals(OtpErlangTuple.class)) {
                args = new OtpErlangObject[((OtpErlangTuple)objects).arity()];
                for (int i = 0; i < ((OtpErlangTuple)objects).arity(); ++i) {
                    args[i] = ((OtpErlangTuple)objects).elementAt(i);
                }
            } else {
                args = new OtpErlangObject[]{objects};
            }
            result = new Object[args.length];
            try {
                for (int i = 0; i < args.length; ++i) {
                    TypeHelper helper = TypeHelpersProxy.getTypeHelper(forClass[i], notes[i]);
                    result[i] = helper.toJava(args[i], forClass[i]);
                }
            }
            catch (Exception e) {
                if (!e.getClass().equals(ClassCastException.class) && !e.getClass().equals(ArrayIndexOutOfBoundsException.class)) break block6;
                throw new TypeMismatchException();
            }
        }
        return result;
    }

    static {
        primitiveTypes = new HashMap();
        primitiveTypes.put(Boolean.TYPE, new BooleanTypeHelper());
        primitiveTypes.put(Short.TYPE, new ShortTypeHelper());
        primitiveTypes.put(Byte.TYPE, new ByteTypeHelper());
        primitiveTypes.put(Character.TYPE, new CharTypeHelper());
        primitiveTypes.put(Integer.TYPE, new IntTypeHelper());
        primitiveTypes.put(Long.TYPE, new LongTypeHelper());
        primitiveTypes.put(Float.TYPE, new FloatTypeHelper());
        primitiveTypes.put(Double.TYPE, new DoubleTypeHelper());
        primitiveTypes.put(String.class, new StringTypeHelper());
        primitiveTypes.put(Boolean.class, primitiveTypes.get(Boolean.TYPE));
        primitiveTypes.put(Character.class, primitiveTypes.get(Character.TYPE));
        primitiveTypes.put(Short.class, primitiveTypes.get(Character.TYPE));
        primitiveTypes.put(Byte.class, primitiveTypes.get(Byte.TYPE));
        primitiveTypes.put(Short.class, primitiveTypes.get(Short.TYPE));
        primitiveTypes.put(Integer.class, primitiveTypes.get(Integer.TYPE));
        primitiveTypes.put(Long.class, primitiveTypes.get(Long.TYPE));
        primitiveTypes.put(Float.class, primitiveTypes.get(Float.TYPE));
        primitiveTypes.put(Double.class, primitiveTypes.get(Double.TYPE));
        primitiveTypes.put(byte[].class, new BinaryTypeHelper());
        primitiveTypes.put(ErlangAtom.class, new AtomTypeHelper());
    }
}

