/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.gdata.provider;

import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Query;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Entry;
import com.google.gdata.data.Feed;
import com.google.gdata.util.ResourceNotFoundException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.tuscany.sca.binding.gdata.provider.GdataBindingUtil;
import org.apache.tuscany.sca.binding.gdata.provider.GdataReferenceBindingProvider;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.osoa.sca.ServiceRuntimeException;

class GdataBindingInvoker
implements Invoker,
DataExchangeSemantics {
    Operation operation;
    String uri;
    HttpClient httpClient;
    String authorizationHeader;
    GdataReferenceBindingProvider provider;
    GoogleService googleService;

    GdataBindingInvoker(Operation operation, String uri, GoogleService googleService, HttpClient httpClient, String authorizationHeader, GdataReferenceBindingProvider bindingProvider) {
        this.operation = operation;
        this.uri = uri;
        this.googleService = googleService;
        this.httpClient = httpClient;
        this.authorizationHeader = authorizationHeader;
        this.provider = bindingProvider;
    }

    public boolean allowsPassByReference() {
        return true;
    }

    public Message invoke(Message msg) {
        throw new UnsupportedOperationException(this.operation.getName());
    }

    public static class PutMediaInvoker
    extends GdataBindingInvoker {
        public PutMediaInvoker(Operation operation, String uri, GoogleService googleService, HttpClient httpClient, String authorizationHeader, GdataReferenceBindingProvider bindingProvider) {
            super(operation, uri, googleService, httpClient, authorizationHeader, bindingProvider);
        }

        public Message invoke(Message msg) {
            return super.invoke(msg);
        }
    }

    public static class PostMediaInvoker
    extends GdataBindingInvoker {
        public PostMediaInvoker(Operation operation, String uri, GoogleService googleService, HttpClient httpClient, String authorizationHeader, GdataReferenceBindingProvider bindingProvider) {
            super(operation, uri, googleService, httpClient, authorizationHeader, bindingProvider);
        }

        public Message invoke(Message msg) {
            return super.invoke(msg);
        }
    }

    public static class QueryInvoker
    extends GdataBindingInvoker {
        public QueryInvoker(Operation operation, String uri, GoogleService googleService, HttpClient httpClient, String authorizationHeader, GdataReferenceBindingProvider bindingProvider) {
            super(operation, uri, googleService, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            GetMethod getMethod = new GetMethod(this.uri);
            getMethod.setRequestHeader("Authorization", this.authorizationHeader);
            Object[] args = (Object[])msg.getBody();
            Query myQuery = (Query)args[0];
            try {
                Feed resultFeed = (Feed)this.googleService.query(myQuery, Feed.class);
                msg.setBody(resultFeed);
            }
            catch (ResourceNotFoundException ex) {
                msg.setFaultBody(new ResourceNotFoundException("Invalid Resource at " + this.uri));
            }
            catch (ServiceException ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            catch (Exception ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            finally {
                return msg;
            }
        }
    }

    public static class GetAllInvoker
    extends GdataBindingInvoker {
        public GetAllInvoker(Operation operation, String uri, GoogleService googleService, HttpClient httpClient, String authorizationHeader, GdataReferenceBindingProvider bindingProvider) {
            super(operation, uri, googleService, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            GetMethod getMethod = new GetMethod(this.uri);
            getMethod.setRequestHeader("Authorization", this.authorizationHeader);
            try {
                Feed feed = (Feed)this.googleService.getFeed(new URL(this.uri), Feed.class);
                msg.setBody(feed);
            }
            catch (ResourceNotFoundException ex) {
                msg.setFaultBody(new ResourceNotFoundException("Invalid Resource at " + this.uri));
            }
            catch (ServiceException ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            catch (Exception ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            finally {
                return msg;
            }
        }
    }

    public static class DeleteInvoker
    extends GdataBindingInvoker {
        public DeleteInvoker(Operation operation, String uri, GoogleService googleService, HttpClient httpClient, String authorizationHeader, GdataReferenceBindingProvider bindingProvider) {
            super(operation, uri, googleService, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            String id = (String)((Object[])msg.getBody())[0];
            DeleteMethod deleteMethod = new DeleteMethod(this.uri + "/" + id);
            deleteMethod.setRequestHeader("Authorization", this.authorizationHeader);
            try {
                URL entryURL = new URL(this.uri + "/" + id);
                Entry toUpdateEntry = (Entry)this.googleService.getEntry(entryURL, Entry.class);
                URL editURL = new URL(toUpdateEntry.getEditLink().getHref());
                this.googleService.delete(editURL);
            }
            catch (IOException ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            catch (ServiceException ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            finally {
                return msg;
            }
        }
    }

    public static class PutInvoker
    extends GdataBindingInvoker {
        public PutInvoker(Operation operation, String uri, GoogleService googleService, HttpClient httpClient, String authorizationHeader, GdataReferenceBindingProvider bindingProvider) {
            super(operation, uri, googleService, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            String id;
            Object[] args = (Object[])msg.getBody();
            Entry feedEntry = null;
            if (this.provider.supportsFeedEntries()) {
                id = (String)args[0];
                feedEntry = (Entry)args[1];
            } else {
                id = (String)args[0];
                org.apache.tuscany.sca.data.collection.Entry<String, Object> entry = new org.apache.tuscany.sca.data.collection.Entry<String, Object>(id, args[1]);
            }
            PutMethod putMethod = new PutMethod(this.uri + "/" + id);
            putMethod.setRequestHeader("Authorization", this.authorizationHeader);
            try {
                URL entryURL = new URL(this.uri + "/" + id);
                Entry toUpdateEntry = (Entry)this.googleService.getEntry(entryURL, Entry.class);
                URL editURL = new URL(toUpdateEntry.getEditLink().getHref());
                Entry updatedEntry = (Entry)this.googleService.update(editURL, (BaseEntry)feedEntry);
                msg.setBody(updatedEntry);
            }
            catch (IOException ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            catch (ServiceException ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            finally {
                return msg;
            }
        }
    }

    public static class PostInvoker
    extends GdataBindingInvoker {
        public PostInvoker(Operation operation, String uri, GoogleService googleService, HttpClient httpClient, String authorizationHeader, GdataReferenceBindingProvider bindingProvider) {
            super(operation, uri, googleService, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            Object[] args = (Object[])msg.getBody();
            Entry feedEntry = null;
            if (this.provider.supportsFeedEntries()) {
                feedEntry = (Entry)args[0];
            } else {
                org.apache.tuscany.sca.data.collection.Entry<Object, Object> entry = new org.apache.tuscany.sca.data.collection.Entry<Object, Object>(args[0], args[1]);
                feedEntry = GdataBindingUtil.feedEntry(entry, this.provider.getItemClassType(), this.provider.getItemXMLType(), this.provider.getMediator());
            }
            try {
                Entry createdEntry = (Entry)this.googleService.insert(new URL(this.uri), (BaseEntry)feedEntry);
                msg.setBody(createdEntry);
            }
            catch (IOException ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            catch (ServiceException ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            finally {
                return msg;
            }
        }
    }

    public static class GetInvoker
    extends GdataBindingInvoker {
        public GetInvoker(Operation operation, String uri, GoogleService googleService, HttpClient httpClient, String authorizationHeader, GdataReferenceBindingProvider bindingProvider) {
            super(operation, uri, googleService, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message invoke(Message msg) {
            String id = (String)((Object[])msg.getBody())[0];
            GetMethod getMethod = new GetMethod(this.uri + "/" + id);
            getMethod.setRequestHeader("Authorization", this.authorizationHeader);
            try {
                URL entryURL = new URL(this.uri + "/" + id);
                Entry feedEntry = (Entry)this.googleService.getEntry(entryURL, Entry.class);
                msg.setBody(feedEntry);
            }
            catch (IOException ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            catch (ServiceException ex) {
                msg.setFaultBody(new ServiceRuntimeException(ex));
            }
            finally {
                return msg;
            }
        }
    }
}

