/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.gdata.provider;

import com.google.gdata.data.Entry;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Feed;
import com.google.gdata.data.ParseSource;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.abdera.parser.ParseException;
import org.apache.tuscany.sca.binding.gdata.provider.GdataBindingUtil;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeWire;

class GdataBindingListenerServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(GdataBindingListenerServlet.class.getName());
    private static final long serialVersionUID = 1L;
    private RuntimeWire wire;
    private Invoker getFeedInvoker;
    private Invoker getAllInvoker;
    private Invoker queryInvoker;
    private Invoker getInvoker;
    private Invoker postInvoker;
    private Invoker postMediaInvoker;
    private Invoker putInvoker;
    private Invoker putMediaInvoker;
    private Invoker deleteInvoker;
    private MessageFactory messageFactory;
    private String title;
    private Mediator mediator;
    private DataType<?> itemClassType;
    private DataType<?> itemXMLType;
    private boolean supportsFeedEntries;

    GdataBindingListenerServlet(RuntimeWire wire, MessageFactory messageFactory, Mediator mediator, String title) {
        this.wire = wire;
        this.messageFactory = messageFactory;
        this.mediator = mediator;
        this.title = title;
        Operation getOperation = null;
        for (InvocationChain invocationChain : this.wire.getInvocationChains()) {
            invocationChain.setAllowsPassByReference(true);
            Operation operation = invocationChain.getTargetOperation();
            String operationName = operation.getName();
            if (operationName.equals("getFeed")) {
                this.getFeedInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("getAll")) {
                this.getAllInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("query")) {
                this.queryInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("get")) {
                this.getInvoker = invocationChain.getHeadInvoker();
                getOperation = operation;
                continue;
            }
            if (operationName.equals("put")) {
                this.putInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("putMedia")) {
                this.putMediaInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("post")) {
                this.postInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("postMedia")) {
                this.postMediaInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (!operationName.equals("delete")) continue;
            this.deleteInvoker = invocationChain.getHeadInvoker();
        }
        this.itemXMLType = new DataTypeImpl<Class<String>>(String.class.getName(), String.class, String.class);
        Class<?> itemClass = getOperation.getOutputType().getPhysical();
        if (itemClass == Entry.class) {
            this.supportsFeedEntries = true;
        }
        DataType outputType = getOperation.getOutputType();
        QName qname = ((XMLType)outputType.getLogical()).getElementName();
        qname = new QName(qname.getNamespaceURI(), itemClass.getSimpleName());
        this.itemClassType = new DataTypeImpl<XMLType>("java:complexType", itemClass, new XMLType(qname, null));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        logger.fine("get " + request.getRequestURI());
        if (path == null || !path.equals("/atomsvc")) {
            if (path == null || path.length() == 0 || path.equals("/")) {
                Message responseMessage;
                Message requestMessage;
                Feed feed = null;
                if (this.supportsFeedEntries) {
                    requestMessage = this.messageFactory.createMessage();
                    if (request.getQueryString() != null) {
                        requestMessage.setBody(new Object[]{request.getQueryString()});
                        responseMessage = this.queryInvoker.invoke(requestMessage);
                    } else {
                        responseMessage = this.getFeedInvoker.invoke(requestMessage);
                    }
                    if (responseMessage.isFault()) {
                        throw new ServletException((Throwable)responseMessage.getBody());
                    }
                    feed = (Feed)responseMessage.getBody();
                } else {
                    requestMessage = this.messageFactory.createMessage();
                    if (request.getQueryString() != null) {
                        requestMessage.setBody(new Object[]{request.getQueryString()});
                        responseMessage = this.queryInvoker.invoke(requestMessage);
                    } else {
                        responseMessage = this.getAllInvoker.invoke(requestMessage);
                    }
                    if (responseMessage.isFault()) {
                        throw new ServletException((Throwable)responseMessage.getBody());
                    }
                    org.apache.tuscany.sca.data.collection.Entry[] collection = (org.apache.tuscany.sca.data.collection.Entry[])responseMessage.getBody();
                    if (collection != null) {
                        feed = new Feed();
                        if (this.title != null) {
                            feed.setTitle((TextConstruct)new PlainTextConstruct(this.title));
                        } else {
                            feed.setTitle((TextConstruct)new PlainTextConstruct("Feed title"));
                        }
                        ArrayList<Entry> entries = new ArrayList<Entry>();
                        for (org.apache.tuscany.sca.data.collection.Entry entry : collection) {
                            Entry feedEntry = GdataBindingUtil.feedEntry(entry, this.itemClassType, this.itemXMLType, this.mediator);
                            entries.add(feedEntry);
                        }
                        feed.setEntries(entries);
                    }
                }
                if (feed != null) {
                    response.setContentType("application/atom+xml; charset=utf-8");
                    StringWriter stringWriter = new StringWriter();
                    XmlWriter w = new XmlWriter((Writer)stringWriter);
                    feed.generateAtom(w, new ExtensionProfile());
                    w.flush();
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)response.getOutputStream());
                    PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
                    out.println(stringWriter.toString());
                    out.close();
                } else {
                    response.sendError(404);
                }
            } else if (path.startsWith("/")) {
                Entry feedEntry = null;
                Message requestMessage = this.messageFactory.createMessage();
                String id = path.substring(1);
                requestMessage.setBody(new Object[]{id});
                Message responseMessage = this.getInvoker.invoke(requestMessage);
                if (responseMessage.isFault()) {
                    throw new ServletException((Throwable)responseMessage.getBody());
                }
                if (this.supportsFeedEntries) {
                    feedEntry = (Entry)responseMessage.getBody();
                } else {
                    org.apache.tuscany.sca.data.collection.Entry entry = new org.apache.tuscany.sca.data.collection.Entry(id, responseMessage.getBody());
                }
                if (feedEntry != null) {
                    response.setContentType("application/atom+xml; charset=utf-8");
                    StringWriter stringWriter = new StringWriter();
                    XmlWriter w = new XmlWriter((Writer)stringWriter);
                    feedEntry.generateAtom(w, new ExtensionProfile());
                    w.flush();
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)response.getOutputStream());
                    PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
                    out.println(stringWriter.toString());
                    out.close();
                } else {
                    response.sendError(404);
                }
            } else {
                response.sendError(404);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String user = this.processAuthorizationHeader(request);
        if (user == null) {
            this.unauthorized(response);
            return;
        }
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        if (path == null || path.length() == 0 || path.equals("/")) {
            Message responseMessage;
            Entry createdFeedEntry = null;
            String contentType = request.getContentType();
            if (contentType != null && contentType.startsWith("application/atom+xml")) {
                Message requestMessage;
                Entry feedEntry = null;
                try {
                    ParseSource source = new ParseSource((Reader)request.getReader());
                    feedEntry = (Entry)Entry.readEntry((ParseSource)source, Entry.class, null);
                }
                catch (ParseException pe) {
                    throw new ServletException((Throwable)pe);
                }
                catch (com.google.gdata.util.ParseException e) {
                    e.printStackTrace();
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                if (this.supportsFeedEntries) {
                    requestMessage = this.messageFactory.createMessage();
                    requestMessage.setBody(new Object[]{feedEntry});
                    Message responseMessage2 = this.postInvoker.invoke(requestMessage);
                    if (responseMessage2.isFault()) {
                        throw new ServletException((Throwable)responseMessage2.getBody());
                    }
                    createdFeedEntry = (Entry)responseMessage2.getBody();
                } else {
                    requestMessage = this.messageFactory.createMessage();
                    org.apache.tuscany.sca.data.collection.Entry<Object, Object> entry = GdataBindingUtil.entry(feedEntry, this.itemClassType, this.itemXMLType, this.mediator);
                    requestMessage.setBody(new Object[]{entry.getKey(), entry.getData()});
                    responseMessage = this.postInvoker.invoke(requestMessage);
                    if (responseMessage.isFault()) {
                        throw new ServletException((Throwable)responseMessage.getBody());
                    }
                    entry.setKey(responseMessage.getBody());
                    createdFeedEntry = GdataBindingUtil.feedEntry(entry, this.itemClassType, this.itemXMLType, this.mediator);
                }
            } else if (contentType != null) {
                String title = request.getHeader("Title");
                String slug = request.getHeader("Slug");
                Message requestMessage = this.messageFactory.createMessage();
                requestMessage.setBody(new Object[]{title, slug, contentType, request.getInputStream()});
                responseMessage = this.postMediaInvoker.invoke(requestMessage);
                if (responseMessage.isFault()) {
                    throw new ServletException((Throwable)responseMessage.getBody());
                }
                createdFeedEntry = (Entry)responseMessage.getBody();
            } else {
                response.sendError(415);
            }
            if (createdFeedEntry != null) {
                response.setStatus(201);
                response.setContentType("application/atom+xml; charset=utf-8");
                try {
                    StringWriter stringWriter = new StringWriter();
                    XmlWriter w = new XmlWriter((Writer)stringWriter);
                    createdFeedEntry.generateAtom(w, new ExtensionProfile());
                    w.flush();
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)response.getOutputStream());
                    PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
                    out.println(stringWriter.toString());
                    out.close();
                }
                catch (ParseException pe) {
                    throw new ServletException((Throwable)pe);
                }
            } else {
                response.sendError(404);
            }
        } else {
            response.sendError(404);
        }
    }

    private Writer getWriter(HttpServletResponse response) throws UnsupportedEncodingException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
        return writer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String user = this.processAuthorizationHeader(request);
        if (user == null) {
            this.unauthorized(response);
            return;
        }
        String path = request.getRequestURI().substring(request.getServletPath().length());
        if (path != null && path.startsWith("/")) {
            String id = path.substring(1);
            String contentType = request.getContentType();
            if (contentType != null && contentType.startsWith("application/atom+xml")) {
                Message requestMessage;
                Entry feedEntry = null;
                try {
                    ParseSource source = new ParseSource((Reader)request.getReader());
                    feedEntry = (Entry)Entry.readEntry((ParseSource)source, Entry.class, null);
                }
                catch (ParseException pe) {
                    throw new ServletException((Throwable)pe);
                }
                catch (com.google.gdata.util.ParseException e) {
                    e.printStackTrace();
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                if (this.supportsFeedEntries) {
                    requestMessage = this.messageFactory.createMessage();
                    requestMessage.setBody(new Object[]{id, feedEntry});
                    Message responseMessage = this.putInvoker.invoke(requestMessage);
                    if (responseMessage.isFault()) {
                        Object body = responseMessage.getBody();
                        if (!body.getClass().getName().endsWith(".NotFoundException")) throw new ServletException((Throwable)responseMessage.getBody());
                        response.sendError(404);
                    }
                } else {
                    requestMessage = this.messageFactory.createMessage();
                    org.apache.tuscany.sca.data.collection.Entry<Object, Object> entry = GdataBindingUtil.entry(feedEntry, this.itemClassType, this.itemXMLType, this.mediator);
                    requestMessage.setBody(new Object[]{entry.getKey(), entry.getData()});
                    Message responseMessage = this.putInvoker.invoke(requestMessage);
                    if (responseMessage.isFault()) {
                        Object body = responseMessage.getBody();
                        if (!body.getClass().getName().endsWith(".NotFoundException")) throw new ServletException((Throwable)responseMessage.getBody());
                        response.sendError(404);
                    }
                }
                if (feedEntry == null) return;
                response.setContentType("application/atom+xml; charset=utf-8");
                StringWriter stringWriter = new StringWriter();
                XmlWriter w = new XmlWriter((Writer)stringWriter);
                feedEntry.generateAtom(w, new ExtensionProfile());
                w.flush();
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)response.getOutputStream());
                PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
                out.println(stringWriter.toString());
                out.close();
                return;
            }
            if (contentType != null) {
                Message requestMessage = this.messageFactory.createMessage();
                requestMessage.setBody(new Object[]{id, contentType, request.getInputStream()});
                Message responseMessage = this.putMediaInvoker.invoke(requestMessage);
                Object body = responseMessage.getBody();
                if (!responseMessage.isFault()) return;
                if (!body.getClass().getName().endsWith(".NotFoundException")) throw new ServletException((Throwable)responseMessage.getBody());
                response.sendError(404);
                return;
            } else {
                response.sendError(415);
            }
            return;
        }
        response.sendError(404);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String user = this.processAuthorizationHeader(request);
        if (user == null) {
            this.unauthorized(response);
            return;
        }
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        String id = path != null && path.startsWith("/") ? path.substring(1) : "";
        Message requestMessage = this.messageFactory.createMessage();
        requestMessage.setBody(new Object[]{id});
        Message responseMessage = this.deleteInvoker.invoke(requestMessage);
        if (responseMessage.isFault()) {
            Object body = responseMessage.getBody();
            if (body.getClass().getName().endsWith(".NotFoundException")) {
                response.sendError(404);
            } else {
                throw new ServletException((Throwable)responseMessage.getBody());
            }
        }
    }

    private String processAuthorizationHeader(HttpServletRequest request) throws ServletException {
        return "admin";
    }

    private boolean authenticate(String user, String password) {
        return "admin".equals(user) && "admin".equals(password);
    }

    private void unauthorized(HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "BASIC realm=\"Tuscany\"");
        response.sendError(401);
    }
}

