/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.gdata.provider;

import com.google.gdata.util.AuthenticationException;
import org.apache.tuscany.sca.binding.gdata.GdataBinding;
import org.apache.tuscany.sca.binding.gdata.provider.GdataReferenceBindingProvider;
import org.apache.tuscany.sca.binding.gdata.provider.GdataServiceBindingProvider;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdataBindingProviderFactory
implements BindingProviderFactory<GdataBinding> {
    private MessageFactory messageFactory;
    private Mediator mediator;
    private ServletHost servletHost;

    public GdataBindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        ServletHostExtensionPoint servletHosts = extensionPoints.getExtensionPoint(ServletHostExtensionPoint.class);
        this.servletHost = servletHosts.getServletHosts().get(0);
        ModelFactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.messageFactory = modelFactories.getFactory(MessageFactory.class);
        this.mediator = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class).getUtility(Mediator.class);
    }

    @Override
    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, GdataBinding binding) {
        try {
            return new GdataReferenceBindingProvider(component, reference, binding, this.mediator);
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ServiceBindingProvider createServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, GdataBinding binding) {
        return new GdataServiceBindingProvider(component, service, binding, this.servletHost, this.messageFactory, this.mediator);
    }

    @Override
    public Class<GdataBinding> getModelType() {
        return GdataBinding.class;
    }
}

