/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.gdata.provider;

import com.google.gdata.client.GoogleService;
import com.google.gdata.data.Entry;
import com.google.gdata.util.AuthenticationException;
import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.tuscany.sca.binding.gdata.GdataBinding;
import org.apache.tuscany.sca.binding.gdata.provider.GdataBindingInvoker;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GdataReferenceBindingProvider
implements ReferenceBindingProvider {
    private RuntimeComponentReference reference;
    private GdataBinding binding;
    private String authorizationHeader;
    private GoogleService googleService;
    private HttpClient httpClient;
    private Mediator mediator;
    private DataType<?> itemClassType;
    private DataType<?> itemXMLType;
    private boolean supportsFeedEntries;

    GdataReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, GdataBinding binding, Mediator mediator) throws AuthenticationException {
        this.reference = reference;
        this.binding = binding;
        this.mediator = mediator;
        String authorization = "admin:admin";
        this.authorizationHeader = "Basic " + new String(Base64.encodeBase64((byte[])authorization.getBytes()));
        String serviceType = binding.getServiceType();
        String usernane = binding.getUsername();
        String password = binding.getPassword();
        this.googleService = new GoogleService(serviceType, "");
        if (!binding.getUsername().equals("admin") && !binding.getPassword().equals("admin")) {
            this.googleService.setUserCredentials(binding.getUsername(), binding.getPassword());
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
        connectionManager.getParams().setConnectionTimeout(60000);
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
    }

    @Override
    public Invoker createInvoker(Operation operation) {
        String operationName = operation.getName();
        if (operationName.equals("get")) {
            String entryURI;
            this.itemXMLType = new DataTypeImpl<Class<String>>(String.class.getName(), String.class, String.class);
            Class<?> itemClass = operation.getOutputType().getPhysical();
            DataType outputType = operation.getOutputType();
            QName qname = ((XMLType)outputType.getLogical()).getElementName();
            qname = new QName(qname.getNamespaceURI(), itemClass.getSimpleName());
            this.itemClassType = new DataTypeImpl<XMLType>("java:complexType", itemClass, new XMLType(qname, null));
            if (this.itemClassType.getPhysical() == Entry.class) {
                this.supportsFeedEntries = true;
            }
            if ((entryURI = this.binding.getURI()).contains("picasaweb.google.com/data/feed/api/")) {
                entryURI = entryURI.replace("picasaweb.google.com/data/feed/api/", "picasaweb.google.com/data/entry/api/");
            }
            return new GdataBindingInvoker.GetInvoker(operation, entryURI, this.googleService, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("post")) {
            return new GdataBindingInvoker.PostInvoker(operation, this.binding.getURI(), this.googleService, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("put")) {
            String entryURI = this.binding.getURI();
            if (entryURI.contains("picasaweb.google.com/data/feed/api/")) {
                entryURI = entryURI.replace("picasaweb.google.com/data/feed/api/", "picasaweb.google.com/data/entry/api/");
            }
            return new GdataBindingInvoker.PutInvoker(operation, entryURI, this.googleService, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("delete")) {
            String entryURI = this.binding.getURI();
            if (entryURI.contains("picasaweb.google.com/data/feed/api/")) {
                entryURI = entryURI.replace("picasaweb.google.com/data/feed/api/", "picasaweb.google.com/data/entry/api/");
            }
            return new GdataBindingInvoker.DeleteInvoker(operation, entryURI, this.googleService, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("getFeed") || operationName.equals("getAll")) {
            return new GdataBindingInvoker.GetAllInvoker(operation, this.binding.getURI(), this.googleService, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("postMedia")) {
            return new GdataBindingInvoker.PostMediaInvoker(operation, this.binding.getURI(), this.googleService, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("putMedia")) {
            return new GdataBindingInvoker.PutMediaInvoker(operation, this.binding.getURI(), this.googleService, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("query")) {
            return new GdataBindingInvoker.QueryInvoker(operation, this.binding.getURI(), this.googleService, this.httpClient, this.authorizationHeader, this);
        }
        return new GdataBindingInvoker(operation, this.binding.getURI(), this.googleService, this.httpClient, this.authorizationHeader, this);
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.reference.getInterfaceContract();
    }

    @Override
    public void start() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin", "admin");
        this.httpClient.getParams().setAuthenticationPreemptive(true);
        URI uri = URI.create(this.binding.getURI());
        this.httpClient.getState().setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)credentials);
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return false;
    }

    Mediator getMediator() {
        return this.mediator;
    }

    DataType<?> getItemClassType() {
        return this.itemClassType;
    }

    DataType<?> getItemXMLType() {
        return this.itemXMLType;
    }

    boolean supportsFeedEntries() {
        return this.supportsFeedEntries;
    }
}

