/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.operationselector.jsonrpc.provider;

import com.metaparadigm.jsonrpc.JSONRPCResult;
import java.io.CharArrayWriter;
import java.util.List;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.HTTPBindingContext;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.json.JSONObject;

public class JSONRPCOperationSelectorInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeWire runtimeWire;
    private HTTPBinding binding;
    private MessageFactory messageFactory;

    public JSONRPCOperationSelectorInterceptor(HTTPBinding binding, RuntimeWire runtimeWire, MessageFactory messageFactory) {
        this.binding = binding;
        this.runtimeWire = runtimeWire;
        this.messageFactory = messageFactory;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message invoke(Message msg) {
        HTTPBindingContext bindingContext = (HTTPBindingContext)msg.getBindingContext();
        if ("smd".equals(bindingContext.getHttpRequest().getQueryString())) {
            return this.getNext().invoke(msg);
        }
        JSONObject jsonReq = null;
        String method = null;
        try {
            Object[] args = (Object[])msg.getBody();
            CharArrayWriter data = (CharArrayWriter)args[0];
            jsonReq = new JSONObject(data.toString());
            method = jsonReq.getString("method");
        }
        catch (Exception e) {
            RuntimeException exception = new RuntimeException("Unable to parse request", e);
        }
        Operation jsonOperation = this.findOperation(method);
        msg.setOperation(jsonOperation);
        msg.setBody(jsonReq);
        return this.getNext().invoke(msg);
    }

    private Operation findOperation(String method) {
        if (method.contains(".")) {
            method = method.substring(method.lastIndexOf(".") + 1);
        }
        List<Operation> operations = this.runtimeWire.getTarget().getInterfaceContract().getInterface().getOperations();
        Operation result = null;
        for (Operation o : operations) {
            if (!o.getName().equalsIgnoreCase(method)) continue;
            result = o;
            break;
        }
        return result;
    }

    private Message createJSONFaultMessage(Throwable throwable) {
        Message jsonFaultMessage = this.messageFactory.createMessage();
        JSONRPCResult jsonFault = new JSONRPCResult(490, null, (Object)throwable);
        jsonFaultMessage.setBody(jsonFault);
        return jsonFaultMessage;
    }
}

