/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.wireformat.jsonrpc.provider;

import com.metaparadigm.jsonrpc.JSONRPCResult;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.HTTPBindingContext;
import org.apache.tuscany.sca.binding.http.wireformat.jsonrpc.provider.JavaToSmd;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osoa.sca.ServiceRuntimeException;

public class JSONRPCWireFormatInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeWire runtimeWire;
    private HTTPBinding binding;
    private InterfaceContract serviceContract;
    private MessageFactory messageFactory;

    public JSONRPCWireFormatInterceptor(HTTPBinding binding, RuntimeWire runtimeWire, InterfaceContract serviceContract, MessageFactory messageFactory) {
        this.binding = binding;
        this.runtimeWire = runtimeWire;
        this.serviceContract = serviceContract;
        this.messageFactory = messageFactory;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message invoke(Message msg) {
        HTTPBindingContext bindingContext = (HTTPBindingContext)msg.getBindingContext();
        Message returnMessage = null;
        returnMessage = "smd".equals(bindingContext.getHttpRequest().getQueryString()) ? this.handleSMDInvocation(msg) : this.handleJSONRPCInvocation(msg);
        return returnMessage;
    }

    private Message handleJSONRPCInvocation(Message msg) {
        JSONObject jsonReq = (JSONObject)msg.getBody();
        String method = null;
        Object[] args = null;
        Object id = null;
        try {
            method = jsonReq.getString("method");
            if (method != null && method.indexOf(46) < 0) {
                jsonReq.putOpt("method", (Object)("Service." + method));
            }
            JSONArray array = jsonReq.getJSONArray("params");
            args = new Object[array.length()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = array.get(i);
            }
            id = jsonReq.get("id");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find json method name", e);
        }
        Message responseMessage = null;
        try {
            msg.setBody(args);
            responseMessage = this.runtimeWire.getInvocationChain(msg.getOperation()).getHeadInvoker().invoke(msg);
        }
        catch (RuntimeException re) {
            RuntimeException exception = new RuntimeException("Error invoking service :" + re.getMessage(), re);
            return this.createJSONFaultMessage(re);
        }
        Object result = null;
        if (!responseMessage.isFault()) {
            try {
                result = responseMessage.getBody();
                JSONObject jsonResponse = new JSONObject();
                jsonResponse.put("result", result);
                jsonResponse.putOpt("id", id);
                responseMessage.setBody(jsonResponse);
                return responseMessage;
            }
            catch (Exception e) {
                throw new ServiceRuntimeException("Unable to create JSON response", e);
            }
        }
        Throwable exception = (Throwable)responseMessage.getBody();
        return this.createJSONFaultMessage(exception);
    }

    private Message handleSMDInvocation(Message msg) {
        HTTPBindingContext bindingContext = (HTTPBindingContext)msg.getBindingContext();
        String serviceUrl = bindingContext.getHttpRequest().getRequestURL().toString();
        JavaInterface interfaze = (JavaInterface)this.serviceContract.getInterface();
        String smd = JavaToSmd.interfaceToSmd(interfaze.getJavaClass(), serviceUrl);
        Message smdResponseMessage = this.messageFactory.createMessage();
        smdResponseMessage.setBody(smd);
        return smdResponseMessage;
    }

    private Message createJSONFaultMessage(Throwable throwable) {
        Message jsonFaultMessage = this.messageFactory.createMessage();
        JSONRPCResult jsonFault = new JSONRPCResult(490, null, (Object)throwable);
        jsonFaultMessage.setBody(jsonFault);
        return jsonFaultMessage;
    }
}

