/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.OperationSelector;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.HTTPBindingFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPBindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<HTTPBinding> {
    private static final String BINDING_HTTP = "binding.http";
    private static final QName BINDING_HTTP_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "binding.http");
    private static final String NAME = "name";
    private static final String URI = "uri";
    private HTTPBindingFactory httpBindingFactory;
    private StAXArtifactProcessor<Object> extensionProcessor;
    private StAXAttributeProcessor<Object> extensionAttributeProcessor;
    private PolicyFactory policyFactory;
    private PolicyAttachPointProcessor policyProcessor;
    private Monitor monitor;

    public HTTPBindingProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        ModelFactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.httpBindingFactory = modelFactories.getFactory(HTTPBindingFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.extensionAttributeProcessor = extensionAttributeProcessor;
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        this.monitor = monitor;
    }

    @Override
    public QName getArtifactType() {
        return BINDING_HTTP_QNAME;
    }

    @Override
    public Class<HTTPBinding> getModelType() {
        return HTTPBinding.class;
    }

    @Override
    public HTTPBinding read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        HTTPBinding httpBinding = this.httpBindingFactory.createHTTPBinding();
        this.policyProcessor.readPolicies(httpBinding, reader);
        while (reader.hasNext()) {
            QName elementName = null;
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    elementName = reader.getName();
                    if (BINDING_HTTP_QNAME.equals(elementName)) {
                        String uri;
                        String name = this.getString(reader, NAME);
                        if (name != null) {
                            httpBinding.setName(name);
                        }
                        if ((uri = HTTPBindingProcessor.getURIString(reader, URI)) == null) break;
                        httpBinding.setURI(uri);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader);
                    if (extension == null) break;
                    if (extension instanceof WireFormat) {
                        httpBinding.setRequestWireFormat((WireFormat)extension);
                        break;
                    }
                    if (!(extension instanceof OperationSelector)) break;
                    httpBinding.setOperationSelector((OperationSelector)extension);
                }
            }
            if (event == 2 && BINDING_HTTP_QNAME.equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return httpBinding;
    }

    @Override
    public void write(HTTPBinding httpBinding, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, BINDING_HTTP_QNAME.getNamespaceURI(), BINDING_HTTP_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        this.policyProcessor.writePolicyAttributes(httpBinding, writer);
        if (httpBinding.getName() != null) {
            writer.writeAttribute(NAME, httpBinding.getName());
        }
        if (httpBinding.getURI() != null) {
            writer.writeAttribute(URI, httpBinding.getURI());
        }
        if (httpBinding.getRequestWireFormat() != null) {
            this.extensionProcessor.write(httpBinding.getRequestWireFormat(), writer);
        }
        if (httpBinding.getOperationSelector() != null) {
            this.extensionProcessor.write(httpBinding.getOperationSelector(), writer);
        }
        this.writeEnd(writer);
    }

    @Override
    public void resolve(HTTPBinding model, ModelResolver resolver) throws ContributionResolveException {
        this.policyProcessor.resolvePolicies(model, resolver);
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "binding-http-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }
}

