/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.operationselector.jmsdefault.runtime;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.WireFormatJMSDefault;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.WireFormatJMSTextXML;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class OperationSelectorJMSDefaultServiceInterceptor
implements Interceptor {
    private static final String ON_MESSAGE_METHOD_NAME = "onMessage";
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private RuntimeComponentService service;
    private List<Operation> serviceOperations;

    public OperationSelectorJMSDefaultServiceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        this.service = (RuntimeComponentService)runtimeWire.getTarget().getContract();
        this.serviceOperations = this.service.getInterfaceContract().getInterface().getOperations();
    }

    public Message invoke(Message msg) {
        return this.next.invoke(this.invokeRequest(msg));
    }

    public Message invokeRequest(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = context.getJmsMsg();
        String operationName = this.requestMessageProcessor.getOperationName(jmsMsg);
        Operation operation = this.getTargetOperation(operationName, jmsMsg);
        msg.setOperation(operation);
        return msg;
    }

    protected Operation getTargetOperation(String operationName, javax.jms.Message jmsMsg) {
        Operation operation = null;
        if (this.serviceOperations.size() == 1) {
            operation = this.serviceOperations.get(0);
        } else if (operationName != null) {
            for (Operation op : this.serviceOperations) {
                if (!op.getName().equals(operationName)) continue;
                operation = op;
                break;
            }
        } else if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSDefault || this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSTextXML) {
            block16: {
                try {
                    String operationFromPayload;
                    OMElement rootElement;
                    if (jmsMsg instanceof TextMessage) {
                        String xmlPayload = ((TextMessage)jmsMsg).getText();
                        if (xmlPayload == null) break block16;
                        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xmlPayload));
                        StAXOMBuilder builder = new StAXOMBuilder(reader);
                        rootElement = builder.getDocumentElement();
                        operationFromPayload = rootElement.getLocalName();
                        for (Operation op : this.serviceOperations) {
                            if (!op.getName().equals(operationFromPayload)) continue;
                            operation = op;
                            break block16;
                        }
                        break block16;
                    }
                    if (!(jmsMsg instanceof BytesMessage)) break block16;
                    long noOfBytes = ((BytesMessage)jmsMsg).getBodyLength();
                    byte[] bytes = new byte[(int)noOfBytes];
                    ((BytesMessage)jmsMsg).readBytes(bytes);
                    ((BytesMessage)jmsMsg).reset();
                    if (bytes == null) break block16;
                    XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(bytes));
                    StAXOMBuilder builder = new StAXOMBuilder(reader);
                    rootElement = builder.getDocumentElement();
                    operationFromPayload = rootElement.getLocalName();
                    for (Operation op : this.serviceOperations) {
                        if (!op.getName().equals(operationFromPayload)) continue;
                        operation = op;
                        break;
                    }
                }
                catch (XMLStreamException e) {
                }
                catch (JMSException e) {
                    throw new JMSBindingException(e);
                }
            }
            if (operation == null) {
                for (Operation op : this.serviceOperations) {
                    if (!op.getName().equals(ON_MESSAGE_METHOD_NAME)) continue;
                    operation = op;
                    break;
                }
            }
        }
        if (operation == null) {
            throw new JMSBindingException("Can't find operation " + (operationName != null ? operationName : ON_MESSAGE_METHOD_NAME));
        }
        return operation;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

