/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.policy.authentication.token;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.jms.policy.authentication.token.JMSTokenAuthenticationPolicy;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSTokenAuthenticationPolicyProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<JMSTokenAuthenticationPolicy> {
    @Override
    public QName getArtifactType() {
        return JMSTokenAuthenticationPolicy.JMS_TOKEN_AUTHENTICATION_POLICY_QNAME;
    }

    public JMSTokenAuthenticationPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
    }

    @Override
    public JMSTokenAuthenticationPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        JMSTokenAuthenticationPolicy policy = new JMSTokenAuthenticationPolicy();
        int event = reader.getEventType();
        QName name = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (!name.equals(this.getArtifactType())) break;
                    policy.setTokenName(this.getQName(reader, "tokenName"));
                }
            }
            if (event == 2 && this.getArtifactType().equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policy;
    }

    @Override
    public void write(JMSTokenAuthenticationPolicy policy, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, this.getArtifactType().getLocalPart(), this.getArtifactType().getNamespaceURI());
        writer.writeNamespace("tuscany", "http://tuscany.apache.org/xmlns/sca/1.0");
        if (policy.getTokenName() != null) {
            writer.writeAttribute(prefix, this.getArtifactType().getNamespaceURI(), "tokenName", policy.getTokenName().toString());
        }
        writer.writeEndElement();
    }

    @Override
    public Class<JMSTokenAuthenticationPolicy> getModelType() {
        return JMSTokenAuthenticationPolicy.class;
    }

    @Override
    public void resolve(JMSTokenAuthenticationPolicy arg0, ModelResolver arg1) throws ContributionResolveException {
    }
}

