/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.policy.header;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.policy.header.JMSHeaderPolicy;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

public class JMSHeaderReferencePolicyInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeComponent component;
    private RuntimeComponentReference reference;
    private JMSBinding jmsBinding;
    private PolicySet policySet = null;
    private String context;
    private JMSHeaderPolicy jmsHeaderPolicy;

    public JMSHeaderReferencePolicyInterceptor(String context, RuntimeComponent component, RuntimeComponentReference reference, Binding binding, PolicySet policySet) {
        this.component = component;
        this.reference = reference;
        this.jmsBinding = (JMSBinding)binding;
        this.policySet = policySet;
        this.context = context;
        this.init();
    }

    private void init() {
        if (this.policySet != null) {
            for (Object policyObject : this.policySet.getPolicies()) {
                if (!(policyObject instanceof JMSHeaderPolicy)) continue;
                this.jmsHeaderPolicy = (JMSHeaderPolicy)policyObject;
                break;
            }
        }
    }

    public Message invoke(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = (javax.jms.Message)msg.getBody();
        return this.getNext().invoke(msg);
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

