/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.AbstractMessageProcessor;

public class BytesMessageProcessor
extends AbstractMessageProcessor {
    private static final Logger logger = Logger.getLogger(AbstractMessageProcessor.class.getName());

    public BytesMessageProcessor(JMSBinding jmsBinding) {
        super(jmsBinding);
    }

    protected Object extractPayload(Message msg) {
        try {
            if (!(msg instanceof BytesMessage)) {
                throw new IllegalStateException("expecting JMS BytesMessage: " + msg);
            }
            long noOfBytes = ((BytesMessage)msg).getBodyLength();
            byte[] bytes = new byte[(int)noOfBytes];
            ((BytesMessage)msg).readBytes(bytes);
            ((BytesMessage)msg).reset();
            return bytes;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    protected Message createJMSMessage(Session session, Object o) {
        if (session == null) {
            logger.fine("no response session to create message: " + String.valueOf(o));
            return null;
        }
        try {
            BytesMessage message = session.createBytesMessage();
            if (o != null) {
                message.writeBytes((byte[])o);
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }
}

