/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.AbstractMessageProcessor;
import org.apache.tuscany.sca.interfacedef.util.FaultException;

public class DefaultMessageProcessor
extends AbstractMessageProcessor {
    private static final Logger logger = Logger.getLogger(DefaultMessageProcessor.class.getName());

    public DefaultMessageProcessor(JMSBinding jmsBinding) {
        super(jmsBinding);
    }

    protected Message createJMSMessage(Session session, Object o) {
        return null;
    }

    protected Object extractPayload(Message msg) {
        return null;
    }

    public Message createFaultMessage(Session session, Throwable o) {
        return this.createFaultJMSBytesMessage(session, o);
    }

    public Object extractPayloadFromJMSTextMessage(Message msg, OMElement wrapper) {
        if (msg instanceof TextMessage) {
            try {
                OMElement os;
                String xml = ((TextMessage)msg).getText();
                if (xml != null) {
                    XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
                    StAXOMBuilder builder = new StAXOMBuilder(reader);
                    os = builder.getDocumentElement();
                } else {
                    os = null;
                }
                if (wrapper != null) {
                    OMElement newWrapper = wrapper.cloneOMElement();
                    if (os != null) {
                        newWrapper.addChild((OMNode)os);
                    }
                    return newWrapper;
                }
                return os;
            }
            catch (XMLStreamException e) {
                throw new JMSBindingException(e);
            }
            catch (JMSException e) {
                throw new JMSBindingException(e);
            }
        }
        return super.extractPayloadFromJMSMessage(msg);
    }

    public Message insertPayloadIntoJMSTextMessage(Session session, Object o, boolean unwrap) {
        try {
            TextMessage message = session.createTextMessage();
            if (o instanceof OMElement) {
                if (unwrap) {
                    OMElement firstElement = ((OMElement)o).getFirstElement();
                    if (firstElement == null) {
                        message.setText(null);
                    } else {
                        message.setText(firstElement.toString());
                    }
                } else {
                    message.setText(o.toString());
                }
            } else if (o instanceof Object[] && ((Object[])o)[0] instanceof OMElement) {
                if (unwrap) {
                    OMElement firstElement = ((OMElement)((Object[])o)[0]).getFirstElement();
                    if (firstElement == null) {
                        message.setText(null);
                    } else {
                        message.setText(firstElement.toString());
                    }
                } else {
                    message.setText(((Object[])o)[0].toString());
                }
            } else if (o != null) {
                throw new IllegalStateException("expecting OMElement payload: " + o);
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public Message createFaultJMSTextMessage(Session session, Throwable o) {
        if (session == null) {
            logger.fine("no response session to create fault message: " + String.valueOf(o));
            return null;
        }
        if (o instanceof FaultException) {
            try {
                TextMessage message = session.createTextMessage();
                message.setText(String.valueOf(((FaultException)o).getFaultInfo()));
                message.setBooleanProperty("org_apache_tuscany_sca_fault", true);
                return message;
            }
            catch (JMSException e) {
                throw new JMSBindingException(e);
            }
        }
        return super.createFaultMessage(session, o);
    }

    public Object extractPayloadFromJMSBytesMessage(Message msg, OMElement wrapper) {
        if (msg instanceof BytesMessage) {
            try {
                OMElement os;
                long noOfBytes = ((BytesMessage)msg).getBodyLength();
                byte[] bytes = new byte[(int)noOfBytes];
                ((BytesMessage)msg).readBytes(bytes);
                ((BytesMessage)msg).reset();
                if (bytes != null && bytes.length > 0) {
                    XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(bytes));
                    StAXOMBuilder builder = new StAXOMBuilder(reader);
                    os = builder.getDocumentElement();
                } else {
                    os = null;
                }
                if (wrapper != null) {
                    OMElement newWrapper = wrapper.cloneOMElement();
                    if (os != null) {
                        newWrapper.addChild((OMNode)os);
                    }
                    return newWrapper;
                }
                return os;
            }
            catch (XMLStreamException e) {
                throw new JMSBindingException(e);
            }
            catch (JMSException e) {
                throw new JMSBindingException(e);
            }
        }
        return super.extractPayloadFromJMSMessage(msg);
    }

    public Message insertPayloadIntoJMSBytesMessage(Session session, Object o, boolean unwrap) {
        try {
            BytesMessage message = session.createBytesMessage();
            if (o instanceof OMElement) {
                if (unwrap) {
                    OMElement firstElement = ((OMElement)o).getFirstElement();
                    if (firstElement != null) {
                        message.writeBytes(firstElement.toString().getBytes());
                    }
                } else {
                    message.writeBytes(o.toString().getBytes());
                }
            } else if (o instanceof Object[] && ((Object[])o)[0] instanceof OMElement) {
                if (unwrap) {
                    OMElement firstElement = ((OMElement)((Object[])o)[0]).getFirstElement();
                    if (firstElement != null) {
                        message.writeBytes(firstElement.toString().getBytes());
                    }
                } else {
                    message.writeBytes(((Object[])o)[0].toString().getBytes());
                }
            } else if (o != null) {
                throw new IllegalStateException("expecting OMElement payload: " + o);
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public Message createFaultJMSBytesMessage(Session session, Throwable o) {
        if (session == null) {
            logger.fine("no response session to create fault message: " + String.valueOf(o));
            return null;
        }
        if (o instanceof FaultException) {
            try {
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(String.valueOf(((FaultException)o).getFaultInfo()).getBytes());
                message.setBooleanProperty("org_apache_tuscany_sca_fault", true);
                return message;
            }
            catch (JMSException e) {
                throw new JMSBindingException(e);
            }
        }
        return super.createFaultMessage(session, o);
    }
}

