/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.transport.TransportServiceInterceptor;
import org.apache.tuscany.sca.binding.jms.wire.CallbackDestinationInterceptor;
import org.apache.tuscany.sca.binding.jms.wire.OperationPropertiesInterceptor;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.host.jms.JMSServiceListener;
import org.apache.tuscany.sca.host.jms.JMSServiceListenerDetails;
import org.apache.tuscany.sca.host.jms.JMSServiceListenerFactory;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.OperationSelectorProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ServiceBindingProviderRRB;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.provider.WireFormatProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class JMSBindingServiceBindingProvider
implements ServiceBindingProviderRRB,
JMSServiceListenerDetails {
    private static final Logger logger = Logger.getLogger(JMSBindingServiceBindingProvider.class.getName());
    private RuntimeComponentService service;
    private Binding targetBinding;
    private JMSBinding jmsBinding;
    private JMSResourceFactory jmsResourceFactory;
    private JMSServiceListenerFactory serviceListenerFactory;
    private JMSServiceListener serviceListener;
    private RuntimeComponent component;
    private InterfaceContract interfaceContract;
    private ProviderFactoryExtensionPoint providerFactories;
    private ModelFactoryExtensionPoint modelFactories;
    private MessageFactory messageFactory;
    private OperationSelectorProviderFactory operationSelectorProviderFactory;
    private OperationSelectorProvider operationSelectorProvider;
    private WireFormatProviderFactory requestWireFormatProviderFactory;
    private WireFormatProvider requestWireFormatProvider;
    private WireFormatProviderFactory responseWireFormatProviderFactory;
    private WireFormatProvider responseWireFormatProvider;

    public JMSBindingServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, Binding targetBinding, JMSBinding binding, JMSServiceListenerFactory serviceListenerFactory, ExtensionPointRegistry extensionPoints, JMSResourceFactory jmsResourceFactory) {
        this.component = component;
        this.service = service;
        this.jmsBinding = binding;
        this.serviceListenerFactory = serviceListenerFactory;
        this.targetBinding = targetBinding;
        this.jmsResourceFactory = jmsResourceFactory;
        if (this.jmsBinding.getDestinationName() == null && (this.jmsBinding.getActivationSpecName() == null || this.jmsBinding.getActivationSpecName().equals("")) && !service.isCallback()) {
            this.jmsBinding.setDestinationName(service.getName());
        }
        this.modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.messageFactory = this.modelFactories.getFactory(MessageFactory.class);
        this.providerFactories = extensionPoints.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.operationSelectorProviderFactory = (OperationSelectorProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getOperationSelector().getClass());
        if (this.operationSelectorProviderFactory != null) {
            this.operationSelectorProvider = this.operationSelectorProviderFactory.createServiceOperationSelectorProvider(component, service, this.jmsBinding);
        }
        this.requestWireFormatProviderFactory = (WireFormatProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getRequestWireFormat().getClass());
        if (this.requestWireFormatProviderFactory != null) {
            this.requestWireFormatProvider = this.requestWireFormatProviderFactory.createServiceWireFormatProvider(component, service, this.jmsBinding);
        }
        this.responseWireFormatProviderFactory = (WireFormatProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getResponseWireFormat().getClass());
        if (this.responseWireFormatProviderFactory != null) {
            this.responseWireFormatProvider = this.responseWireFormatProviderFactory.createServiceWireFormatProvider(component, service, this.jmsBinding);
        }
        try {
            this.interfaceContract = (InterfaceContract)service.getInterfaceContract().clone();
            this.requestWireFormatProvider.configureWireFormatInterfaceContract(this.interfaceContract);
            this.responseWireFormatProvider.configureWireFormatInterfaceContract(this.interfaceContract);
        }
        catch (CloneNotSupportedException ex) {
            this.interfaceContract = service.getInterfaceContract();
        }
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.interfaceContract;
    }

    public boolean supportsOneWayInvocation() {
        return true;
    }

    public void start() {
        try {
            this.serviceListener = this.serviceListenerFactory.createJMSServiceListener(this);
            this.serviceListener.start();
        }
        catch (Exception e) {
            throw new JMSBindingException("Error starting JMSServiceBinding", e);
        }
    }

    public void stop() {
        try {
            this.serviceListener.stop();
        }
        catch (Exception e) {
            throw new JMSBindingException("Error stopping JMSServiceBinding", e);
        }
    }

    public String getDestinationName() {
        return this.serviceListener.getDestinationName();
    }

    public void configureBindingChain(RuntimeWire runtimeWire) {
        InvocationChain bindingChain = runtimeWire.getBindingInvocationChain();
        bindingChain.addInterceptor("service.binding.transport", (Interceptor)new TransportServiceInterceptor(this.jmsBinding, this.jmsResourceFactory, runtimeWire));
        bindingChain.addInterceptor(this.operationSelectorProvider.getPhase(), this.operationSelectorProvider.createInterceptor());
        bindingChain.addInterceptor("service.binding.operationselector", (Interceptor)new OperationPropertiesInterceptor(this.jmsBinding, runtimeWire));
        bindingChain.addInterceptor("service.binding.wireformat", (Interceptor)new CallbackDestinationInterceptor(runtimeWire));
        bindingChain.addInterceptor(this.requestWireFormatProvider.getPhase(), this.requestWireFormatProvider.createInterceptor());
        if (!this.jmsBinding.getRequestWireFormat().equals(this.jmsBinding.getResponseWireFormat())) {
            bindingChain.addInterceptor(this.responseWireFormatProvider.getPhase(), this.responseWireFormatProvider.createInterceptor());
        }
    }

    public RuntimeComponent getComponent() {
        return this.component;
    }

    public RuntimeComponentService getService() {
        return this.service;
    }

    public Binding getTargetBinding() {
        return this.targetBinding;
    }

    public JMSBinding getJmsBinding() {
        return this.jmsBinding;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public JMSResourceFactory getResourceFactory() {
        return this.jmsResourceFactory;
    }
}

