/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.AbstractMessageProcessor;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMessageProcessor
extends AbstractMessageProcessor {
    private static final Logger logger = Logger.getLogger(ObjectMessageProcessor.class.getName());

    public ObjectMessageProcessor(JMSBinding jmsBinding) {
        super(jmsBinding);
    }

    @Override
    protected Message createJMSMessage(Session session, Object o) {
        if (session == null) {
            logger.fine("no response session to create message: " + String.valueOf(o));
            return null;
        }
        try {
            ObjectMessage message = session.createObjectMessage();
            if (o != null) {
                if (!(o instanceof Serializable)) {
                    throw new IllegalStateException("JMS ObjectMessage payload not Serializable: " + o);
                }
                message.setObject((Serializable)o);
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    @Override
    public Object extractPayloadFromJMSMessage(Message msg) {
        try {
            Serializable o = ((ObjectMessage)msg).getObject();
            if (o instanceof Throwable) {
                if (o instanceof RuntimeException) {
                    throw new ServiceRuntimeException("remote service exception, see nested exception", (RuntimeException)o);
                }
                return new InvocationTargetException((Throwable)o);
            }
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
        return this.extractPayload(msg);
    }

    @Override
    protected Object extractPayload(Message msg) {
        try {
            return ((ObjectMessage)msg).getObject();
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public Message createJMSMessageForSingleParamOperation(Session session, Object o, boolean wrapSingleInput) {
        if (session == null) {
            logger.fine("no response session to create message: " + String.valueOf(o));
            return null;
        }
        try {
            ObjectMessage message = session.createObjectMessage();
            if (o != null) {
                if (!(o instanceof Serializable)) {
                    throw new IllegalStateException("JMS ObjectMessage payload not Serializable: " + o);
                }
                if (wrapSingleInput) {
                    message.setObject((Serializable)o);
                } else {
                    message.setObject((Serializable)((Object[])o)[0]);
                }
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public Object extractPayloadFromJMSMessageForSingleParamOperation(Message msg, Class<?> argType, boolean wrapSingle) {
        try {
            Serializable payload = ((ObjectMessage)msg).getObject();
            if (payload instanceof Throwable) {
                if (payload instanceof RuntimeException) {
                    throw new ServiceRuntimeException("remote service exception, see nested exception", (RuntimeException)payload);
                }
                return new InvocationTargetException((Throwable)payload);
            }
            if (payload == null) {
                return new Object[]{payload};
            }
            boolean payloadIsArray = payload.getClass().isArray();
            if (!payloadIsArray) {
                return new Object[]{payload};
            }
            int size = ((Object[])payload).length;
            if (size != 1) {
                return new Object[]{payload};
            }
            Object arrayContents = ((Object[])payload)[0];
            if (argType.isAssignableFrom(payload.getClass())) {
                if (arrayContents == null) {
                    if (wrapSingle) {
                        return payload;
                    }
                    return new Object[]{payload};
                }
                if (argType.isAssignableFrom(arrayContents.getClass())) {
                    if (wrapSingle) {
                        return payload;
                    }
                    return new Object[]{payload};
                }
                return new Object[]{payload};
            }
            return payload;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }
}

