/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.AbstractMessageProcessor;

public class TextMessageProcessor
extends AbstractMessageProcessor {
    private static final Logger logger = Logger.getLogger(TextMessageProcessor.class.getName());

    public TextMessageProcessor(JMSBinding jmsBinding) {
        super(jmsBinding);
    }

    protected Object extractPayload(Message msg) {
        try {
            if (!(msg instanceof TextMessage)) {
                throw new IllegalStateException("expecting JMS TextMessage: " + msg);
            }
            return ((TextMessage)msg).getText();
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    protected Message createJMSMessage(Session session, Object o) {
        if (session == null) {
            logger.fine("no response session to create message: " + String.valueOf(o));
            return null;
        }
        try {
            TextMessage message = session.createTextMessage();
            if (o != null) {
                message.setText(String.valueOf(o));
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }
}

