/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.io.ByteArrayInputStream;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.AbstractMessageProcessor;
import org.apache.tuscany.sca.interfacedef.util.FaultException;

public class XMLBytesMessageProcessor
extends AbstractMessageProcessor {
    private static final Logger logger = Logger.getLogger(XMLBytesMessageProcessor.class.getName());

    public XMLBytesMessageProcessor(JMSBinding jmsBinding) {
        super(jmsBinding);
    }

    protected Object extractPayload(Message msg) {
        try {
            OMElement os;
            if (!(msg instanceof BytesMessage)) {
                throw new IllegalStateException("expecting JMS BytesMessage: " + msg);
            }
            long noOfBytes = ((BytesMessage)msg).getBodyLength();
            byte[] bytes = new byte[(int)noOfBytes];
            ((BytesMessage)msg).readBytes(bytes);
            ((BytesMessage)msg).reset();
            if (noOfBytes > 0L) {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new ByteArrayInputStream(bytes));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                os = builder.getDocumentElement();
            } else {
                os = null;
            }
            return os;
        }
        catch (XMLStreamException e) {
            throw new JMSBindingException(e);
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public Object extractPayloadFromJMSMessage(Message msg) {
        if (msg instanceof BytesMessage) {
            return this.extractPayload(msg);
        }
        return super.extractPayloadFromJMSMessage(msg);
    }

    protected Message createJMSMessage(Session session, Object o) {
        if (session == null) {
            logger.fine("no response session to create message: " + String.valueOf(o));
            return null;
        }
        try {
            BytesMessage message = session.createBytesMessage();
            if (o instanceof OMElement) {
                message.writeBytes(o.toString().getBytes());
            } else if (o instanceof Object[] && ((Object[])o)[0] instanceof OMElement) {
                message.writeBytes(((Object[])o)[0].toString().getBytes());
            } else if (o != null) {
                throw new IllegalStateException("expecting OMElement payload: " + o);
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public Message createFaultMessage(Session session, Throwable o) {
        if (session == null) {
            logger.fine("no response session to create fault message: " + String.valueOf(o));
            return null;
        }
        if (o instanceof FaultException) {
            try {
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(String.valueOf(((FaultException)o).getFaultInfo()).getBytes());
                message.setBooleanProperty("org_apache_tuscany_sca_fault", true);
                return message;
            }
            catch (JMSException e) {
                throw new JMSBindingException(e);
            }
        }
        return super.createFaultMessage(session, o);
    }
}

