/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.io.StringReader;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.AbstractMessageProcessor;
import org.apache.tuscany.sca.interfacedef.util.FaultException;

public class XMLTextMessageProcessor
extends AbstractMessageProcessor {
    private static final Logger logger = Logger.getLogger(XMLTextMessageProcessor.class.getName());

    public XMLTextMessageProcessor(JMSBinding jmsBinding) {
        super(jmsBinding);
    }

    protected Object extractPayload(Message msg) {
        try {
            OMElement os;
            String xml = ((TextMessage)msg).getText();
            if (xml != null) {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                os = builder.getDocumentElement();
            } else {
                os = null;
            }
            return os;
        }
        catch (XMLStreamException e) {
            throw new JMSBindingException(e);
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public Object extractPayloadFromJMSMessage(Message msg) {
        if (msg instanceof TextMessage) {
            return this.extractPayload(msg);
        }
        return super.extractPayloadFromJMSMessage(msg);
    }

    protected Message createJMSMessage(Session session, Object o) {
        if (session == null) {
            logger.fine("no response session to create message: " + String.valueOf(o));
            return null;
        }
        try {
            TextMessage message = session.createTextMessage();
            if (o instanceof OMElement) {
                message.setText(o.toString());
            } else if (o instanceof Object[] && ((Object[])o)[0] instanceof OMElement) {
                message.setText(((Object[])o)[0].toString());
            } else if (o != null) {
                throw new IllegalStateException("expecting OMElement payload: " + o);
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public Message createFaultMessage(Session session, Throwable o) {
        if (session == null) {
            logger.fine("no response session to create fault message: " + String.valueOf(o));
            return null;
        }
        if (o instanceof FaultException) {
            try {
                TextMessage message = session.createTextMessage();
                message.setText(String.valueOf(((FaultException)o).getFaultInfo()));
                message.setBooleanProperty("org_apache_tuscany_sca_fault", true);
                return message;
            }
            catch (JMSException e) {
                throw new JMSBindingException(e);
            }
        }
        return super.createFaultMessage(session, o);
    }
}

