/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.transport;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.core.assembly.EndpointReferenceImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class TransportServiceInterceptor
implements Interceptor {
    private static final Logger logger = Logger.getLogger(TransportServiceInterceptor.class.getName());
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private RuntimeComponentService service;
    private String correlationScheme;

    public TransportServiceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        this.service = (RuntimeComponentService)runtimeWire.getTarget().getContract();
        this.correlationScheme = jmsBinding.getCorrelationScheme();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message invoke(Message msg) {
        Message message;
        try {
            message = this.invokeResponse(this.next.invoke(this.invokeRequest(msg)));
        }
        catch (Throwable e) {
            try {
                logger.log(Level.SEVERE, "Exception invoking service '" + this.service.getName(), e);
                JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
                javax.jms.Message replyJMSMsg = this.responseMessageProcessor.createFaultMessage(context.getJmsResponseSession(), e);
                msg.setBody(replyJMSMsg);
                this.invokeResponse(msg);
                Message message2 = msg;
                return message2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    ((JMSBindingContext)msg.getBindingContext()).closeJmsResponseSession();
                    if (this.jmsResourceFactory.isConnectionClosedAfterUse()) {
                        this.jmsResourceFactory.closeResponseConnection();
                    }
                }
                catch (JMSException e2) {}
            }
        }
        try {
            ((JMSBindingContext)msg.getBindingContext()).closeJmsResponseSession();
            if (!this.jmsResourceFactory.isConnectionClosedAfterUse()) return message;
            this.jmsResourceFactory.closeResponseConnection();
            return message;
        }
        catch (JMSException e) {
            // empty catch block
        }
        return message;
    }

    public Message invokeRequest(Message msg) {
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            javax.jms.Message requestJMSMsg = context.getJmsMsg();
            EndpointReferenceImpl from = new EndpointReferenceImpl(null);
            msg.setFrom(from);
            from.setCallbackEndpoint(new EndpointReferenceImpl("/"));
            ReferenceParameters parameters = from.getReferenceParameters();
            String conversationID = requestJMSMsg.getStringProperty("scaConversationId");
            if (conversationID != null) {
                parameters.setConversationID(conversationID);
            }
            return msg;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public Message invokeResponse(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        try {
            Operation operation = msg.getOperation();
            if (operation != null && operation.isNonBlocking()) {
                Message message = msg;
                return message;
            }
            Session session = context.getJmsResponseSession();
            javax.jms.Message requestJMSMsg = context.getJmsMsg();
            javax.jms.Message responseJMSMsg = (javax.jms.Message)msg.getBody();
            Destination replyDest = requestJMSMsg.getJMSReplyTo();
            if (replyDest == null && this.jmsBinding.getResponseDestinationName() != null) {
                try {
                    replyDest = this.jmsResourceFactory.lookupDestination(this.jmsBinding.getResponseDestinationName());
                }
                catch (NamingException e) {
                    throw new JMSBindingException("Exception lookingup response destination", e);
                }
            }
            if (replyDest == null) {
                if (msg.getBody() != null) {
                    logger.log(Level.FINE, "JMS service '" + this.service.getName() + "' dropped response as request has no replyTo");
                }
                Message e = msg;
                return e;
            }
            responseJMSMsg.setJMSDeliveryMode(requestJMSMsg.getJMSDeliveryMode());
            responseJMSMsg.setJMSPriority(requestJMSMsg.getJMSPriority());
            if (this.correlationScheme == null || "requestmsgidtocorrelid".equalsIgnoreCase(this.correlationScheme)) {
                responseJMSMsg.setJMSCorrelationID(requestJMSMsg.getJMSMessageID());
            } else if ("requestcorrelidtocorrelid".equalsIgnoreCase(this.correlationScheme)) {
                responseJMSMsg.setJMSCorrelationID(requestJMSMsg.getJMSCorrelationID());
            }
            MessageProducer producer = session.createProducer(replyDest);
            int deliveryMode = requestJMSMsg.getJMSDeliveryMode();
            producer.setDeliveryMode(deliveryMode);
            int deliveryPriority = requestJMSMsg.getJMSPriority();
            producer.setPriority(deliveryPriority);
            producer.send((javax.jms.Message)msg.getBody());
            producer.close();
            Message message = msg;
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
        finally {
            context.closeJmsResponseSession();
        }
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

