/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wire;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.core.assembly.EndpointReferenceImpl;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class CallbackDestinationInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeComponentService service;

    public CallbackDestinationInterceptor(RuntimeWire runtimeWire) {
        this.service = (RuntimeComponentService)runtimeWire.getTarget().getContract();
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message invoke(Message msg) {
        return this.next.invoke(this.invokeRequest(msg));
    }

    public Message invokeRequest(Message msg) {
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            javax.jms.Message jmsMsg = context.getJmsMsg();
            ReferenceParameters parameters = msg.getFrom().getReferenceParameters();
            if (this.service.getInterfaceContract().getCallbackInterface() != null) {
                String callbackID;
                Destination replyTo;
                String callbackdestName = jmsMsg.getStringProperty("scaCallbackQueue");
                if (callbackdestName == null && msg.getOperation().isNonBlocking() && (replyTo = jmsMsg.getJMSReplyTo()) != null) {
                    String string = callbackdestName = replyTo instanceof Queue ? ((Queue)replyTo).getQueueName() : ((Topic)replyTo).getTopicName();
                }
                if (callbackdestName != null) {
                    parameters.setCallbackReference(new EndpointReferenceImpl("jms:" + callbackdestName));
                }
                if ((callbackID = jmsMsg.getStringProperty("CallbackID")) != null) {
                    parameters.setCallbackID(callbackID);
                }
            }
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
        return msg;
    }
}

