/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsbytesxml.runtime;

import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsbytesxml.WireFormatJMSBytesXML;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class WireFormatJMSBytesXMLServiceInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;

    public WireFormatJMSBytesXMLServiceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
    }

    public Message invoke(Message msg) {
        Operation operation;
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSBytesXML) {
            msg = this.invokeRequest(msg);
        }
        if ((operation = (msg = this.getNext().invoke(msg)).getOperation()) != null && operation.isNonBlocking()) {
            return msg;
        }
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSBytesXML) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = context.getJmsMsg();
        Object requestPayload = this.requestMessageProcessor.extractPayloadFromJMSMessage(jmsMsg);
        msg.setBody(new Object[]{requestPayload});
        return msg;
    }

    public Message invokeResponse(Message msg) {
        javax.jms.Message responseJMSMsg;
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        Session session = context.getJmsResponseSession();
        if (msg.isFault()) {
            responseJMSMsg = this.responseMessageProcessor.createFaultMessage(session, (Throwable)msg.getBody());
        } else {
            Object response = msg.getBody();
            responseJMSMsg = this.responseMessageProcessor.insertPayloadIntoJMSMessage(session, response);
        }
        msg.setBody(responseJMSMsg);
        return msg;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

