/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.WireFormatJMSDefault;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireFormatJMSDefaultProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WireFormatJMSDefault> {
    @Override
    public QName getArtifactType() {
        return WireFormatJMSDefault.WIRE_FORMAT_JMS_DEFAULT_QNAME;
    }

    public WireFormatJMSDefaultProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
    }

    @Override
    public WireFormatJMSDefault read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        WireFormatJMSDefault wireFormat = new WireFormatJMSDefault();
        String sendFormat = reader.getAttributeValue(null, "sendFormat");
        if (sendFormat != null && sendFormat.length() > 0) {
            if ("text".equalsIgnoreCase(sendFormat)) {
                wireFormat.setUseBytesMessage(false);
            } else if ("bytes".equalsIgnoreCase(sendFormat)) {
                wireFormat.setUseBytesMessage(true);
            } else {
                throw new ContributionReadException(WireFormatJMSDefault.WIRE_FORMAT_JMS_DEFAULT_QNAME.toString() + " " + sendFormat + " is not a valid attribute value for " + "sendFormat");
            }
        }
        return wireFormat;
    }

    @Override
    public void write(WireFormatJMSDefault wireFormat, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, this.getArtifactType().getLocalPart(), this.getArtifactType().getNamespaceURI());
        writer.writeNamespace("tuscany", "http://tuscany.apache.org/xmlns/sca/1.0");
        if (wireFormat.isUseBytesMessage()) {
            writer.writeAttribute("sendFormat", "bytes");
        } else {
            writer.writeAttribute("sendFormat", "text");
        }
        writer.writeEndElement();
    }

    @Override
    public Class<WireFormatJMSDefault> getModelType() {
        return WireFormatJMSDefault.class;
    }

    @Override
    public void resolve(WireFormatJMSDefault arg0, ModelResolver arg1) throws ContributionResolveException {
    }
}

