/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.runtime;

import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.WireFormatJMSDefault;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireFormatJMSDefaultReferenceInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private DefaultMessageProcessor requestMessageProcessor;
    private DefaultMessageProcessor responseMessageProcessor;
    private HashMap<String, Boolean> inputWrapperMap;
    private HashMap<String, OMElement> outputWrapperMap;

    public WireFormatJMSDefaultReferenceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire, HashMap<String, Boolean> inputWrapperMap, HashMap<String, OMElement> outputWrapperMap) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = new DefaultMessageProcessor(jmsBinding);
        this.responseMessageProcessor = new DefaultMessageProcessor(jmsBinding);
        this.inputWrapperMap = inputWrapperMap;
        this.outputWrapperMap = outputWrapperMap;
    }

    @Override
    public Message invoke(Message msg) {
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSDefault) {
            msg = this.invokeRequest(msg);
        }
        msg = this.getNext().invoke(msg);
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSDefault) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            Session session = context.getJmsSession();
            javax.jms.Message requestMsg = ((WireFormatJMSDefault)this.jmsBinding.getRequestWireFormat()).isUseBytesMessage() ? this.requestMessageProcessor.insertPayloadIntoJMSBytesMessage(session, msg.getBody(), this.inputWrapperMap.get(msg.getOperation().getName())) : this.requestMessageProcessor.insertPayloadIntoJMSTextMessage(session, msg.getBody(), this.inputWrapperMap.get(msg.getOperation().getName()));
            msg.setBody(requestMsg);
            requestMsg.setJMSReplyTo(context.getReplyToDestination());
            return msg;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message invokeResponse(Message msg) {
        if (msg.getBody() == null) return msg;
        javax.jms.Message jmsMsg = (javax.jms.Message)msg.getBody();
        Operation op = msg.getOperation();
        DataType outputDataType = op.getOutputType();
        Class<?> outputType = null;
        if (outputDataType != null) {
            outputType = outputDataType.getPhysical();
        }
        if (outputType != null && javax.jms.Message.class.isAssignableFrom(outputType)) {
            msg.setBody(jmsMsg);
            return msg;
        }
        OMElement wrapper = null;
        try {
            if (!jmsMsg.getBooleanProperty("org_apache_tuscany_sca_fault")) {
                wrapper = this.outputWrapperMap.get(msg.getOperation().getName());
            }
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
        Object response = jmsMsg instanceof BytesMessage ? this.responseMessageProcessor.extractPayloadFromJMSBytesMessage(jmsMsg, wrapper) : this.responseMessageProcessor.extractPayloadFromJMSTextMessage(jmsMsg, wrapper);
        if (response != null) {
            msg.setBody(response);
            try {
                if (!jmsMsg.getBooleanProperty("org_apache_tuscany_sca_fault")) return msg;
                FaultException e = new FaultException("remote exception", response);
                OMElement om = (OMElement)response;
                e.setFaultName(new QName(om.getNamespace().getNamespaceURI(), om.getLocalName()));
                msg.setFaultBody(e);
                return msg;
            }
            catch (JMSException e) {
                throw new JMSBindingException(e);
            }
        } else {
            msg.setBody(null);
        }
        return msg;
    }

    @Override
    public Invoker getNext() {
        return this.next;
    }

    @Override
    public void setNext(Invoker next) {
        this.next = next;
    }
}

