/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.runtime;

import java.util.HashMap;
import java.util.List;
import javax.jms.Message;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.WireFormatJMSDefault;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.runtime.WireFormatJMSDefaultReferenceInterceptor;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

public class WireFormatJMSDefaultReferenceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeComponent component;
    private RuntimeComponentReference reference;
    private JMSBinding binding;
    private InterfaceContract interfaceContract;
    private HashMap<String, Boolean> inputWrapperMap;
    private HashMap<String, OMElement> outputWrapperMap;

    public WireFormatJMSDefaultReferenceProvider(ExtensionPointRegistry registry, RuntimeComponent component, RuntimeComponentReference reference, Binding binding) {
        this.registry = registry;
        this.component = component;
        this.reference = reference;
        this.binding = (JMSBinding)binding;
        this.inputWrapperMap = new HashMap();
        this.outputWrapperMap = new HashMap();
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSDefault) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor");
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSDefault) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor");
        }
        if (reference.getReference() == null) {
            this.interfaceContract = reference.getInterfaceContract();
            return;
        }
        List<Operation> opList = reference.getReference().getInterfaceContract().getInterface().getOperations();
        OMFactory factory = OMAbstractFactory.getOMFactory();
        if (reference.getInterfaceContract() != null && !this.isAsIs()) {
            WebServiceBindingFactory wsFactory = registry.getExtensionPoint(WebServiceBindingFactory.class);
            WebServiceBinding wsBinding = wsFactory.createWebServiceBinding();
            BindingWSDLGenerator.generateWSDL(component, reference, wsBinding, registry, null);
            this.interfaceContract = wsBinding.getBindingInterfaceContract();
            this.interfaceContract.getInterface().resetDataBinding(OMElement.class.getName());
            List<Operation> wsdlOpList = this.interfaceContract.getInterface().getOperations();
            for (Operation op : opList) {
                String name = op.getName();
                Operation matchingWsdlOp = null;
                for (Operation wsdlOp : wsdlOpList) {
                    if (!name.equals(wsdlOp.getName())) continue;
                    matchingWsdlOp = wsdlOp;
                    break;
                }
                if (matchingWsdlOp.isInputWrapperStyle()) {
                    if (op.getInputType().getLogical().size() == 1) {
                        this.inputWrapperMap.put(name, true);
                    } else {
                        this.inputWrapperMap.put(name, false);
                    }
                } else {
                    this.inputWrapperMap.put(name, false);
                }
                if (!matchingWsdlOp.isOutputWrapperStyle()) continue;
                ElementInfo ei = op.getOutputWrapper().getWrapperElement();
                String namespace = ei.getQName().getNamespaceURI();
                String opName = ei.getQName().getLocalPart();
                OMNamespace ns = factory.createOMNamespace(namespace, "ns2");
                OMElement wrapper = factory.createOMElement(opName, ns);
                this.outputWrapperMap.put(name, wrapper);
            }
        } else {
            this.interfaceContract = reference.getReference().getInterfaceContract();
        }
    }

    protected boolean isAsIs() {
        InterfaceContract ic = this.reference.getInterfaceContract();
        if (ic.getInterface().getOperations().size() != 1) {
            return false;
        }
        List<DataType> inputDataTypes = ic.getInterface().getOperations().get(0).getInputType().getLogical();
        if (inputDataTypes.size() != 1) {
            return false;
        }
        Class<?> inputType = inputDataTypes.get(0).getPhysical();
        return Message.class.isAssignableFrom(inputType);
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null && !this.isAsIs()) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSDefault) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSDefault) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSDefaultReferenceInterceptor(this.binding, null, this.reference.getRuntimeWire(this.binding), this.inputWrapperMap, this.outputWrapperMap);
    }

    public String getPhase() {
        return "reference.binding.wireformat";
    }
}

