/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.runtime;

import java.util.HashMap;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Session;
import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.WireFormatJMSDefault;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireFormatJMSDefaultServiceInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private DefaultMessageProcessor requestMessageProcessor;
    private DefaultMessageProcessor responseMessageProcessor;
    private HashMap<String, OMElement> inputWrapperMap;
    private HashMap<String, Boolean> outputWrapperMap;

    public WireFormatJMSDefaultServiceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire, HashMap<String, OMElement> inputWrapperMap, HashMap<String, Boolean> outputWrapperMap) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = new DefaultMessageProcessor(jmsBinding);
        this.responseMessageProcessor = new DefaultMessageProcessor(jmsBinding);
        this.inputWrapperMap = inputWrapperMap;
        this.outputWrapperMap = outputWrapperMap;
    }

    @Override
    public Message invoke(Message msg) {
        Operation operation;
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSDefault) {
            msg = this.invokeRequest(msg);
        }
        if ((operation = (msg = this.getNext().invoke(msg)).getOperation()) != null && operation.isNonBlocking()) {
            return msg;
        }
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSDefault) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = context.getJmsMsg();
        Operation op = msg.getOperation();
        List<DataType> inputDataTypes = op.getInputType().getLogical();
        Class<?> inputType = null;
        if (inputDataTypes.size() == 1) {
            inputType = inputDataTypes.get(0).getPhysical();
        }
        if (inputType != null && javax.jms.Message.class.isAssignableFrom(inputType)) {
            msg.setBody(new Object[]{jmsMsg});
            if (jmsMsg instanceof BytesMessage) {
                context.setUseBytesForWFJMSDefaultResponse(true);
            } else {
                context.setUseBytesForWFJMSDefaultResponse(false);
            }
        } else {
            Object requestPayload;
            OMElement wrapper = this.inputWrapperMap.get(msg.getOperation().getName());
            if (jmsMsg instanceof BytesMessage) {
                requestPayload = this.responseMessageProcessor.extractPayloadFromJMSBytesMessage(jmsMsg, wrapper);
                context.setUseBytesForWFJMSDefaultResponse(true);
            } else {
                requestPayload = this.responseMessageProcessor.extractPayloadFromJMSTextMessage(jmsMsg, wrapper);
                context.setUseBytesForWFJMSDefaultResponse(false);
            }
            msg.setBody(new Object[]{requestPayload});
        }
        return msg;
    }

    public Message invokeResponse(Message msg) {
        javax.jms.Message responseJMSMsg;
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        Session session = context.getJmsResponseSession();
        boolean respondBytesMessage = context.isUseBytesForWFJMSDefaultResponse();
        if (msg.isFault()) {
            responseJMSMsg = respondBytesMessage ? this.requestMessageProcessor.createFaultJMSBytesMessage(session, (Throwable)msg.getBody()) : this.responseMessageProcessor.createFaultJMSTextMessage(session, (Throwable)msg.getBody());
        } else {
            boolean unwrap = false;
            if (this.outputWrapperMap.get(msg.getOperation().getName()) != null) {
                unwrap = this.outputWrapperMap.get(msg.getOperation().getName());
            }
            responseJMSMsg = respondBytesMessage ? this.requestMessageProcessor.insertPayloadIntoJMSBytesMessage(session, msg.getBody(), unwrap) : this.requestMessageProcessor.insertPayloadIntoJMSTextMessage(session, msg.getBody(), unwrap);
        }
        msg.setBody(responseJMSMsg);
        return msg;
    }

    @Override
    public Invoker getNext() {
        return this.next;
    }

    @Override
    public void setNext(Invoker next) {
        this.next = next;
    }
}

