/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.runtime;

import java.util.HashMap;
import java.util.List;
import javax.jms.Message;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.WireFormatJMSDefault;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.runtime.WireFormatJMSDefaultServiceInterceptor;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class WireFormatJMSDefaultServiceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private JMSBinding binding;
    private JMSResourceFactory jmsResourceFactory;
    private InterfaceContract interfaceContract;
    private HashMap<String, OMElement> inputWrapperMap;
    private HashMap<String, Boolean> outputWrapperMap;

    public WireFormatJMSDefaultServiceProvider(ExtensionPointRegistry registry, RuntimeComponent component, RuntimeComponentService service, Binding binding, JMSResourceFactory jmsResourceFactory) {
        this.component = component;
        this.service = service;
        this.binding = (JMSBinding)binding;
        this.jmsResourceFactory = jmsResourceFactory;
        this.inputWrapperMap = new HashMap();
        this.outputWrapperMap = new HashMap();
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSDefault) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor");
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSDefault) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor");
        }
        List<Operation> opList = service.getService().getInterfaceContract().getInterface().getOperations();
        OMFactory factory = OMAbstractFactory.getOMFactory();
        if (service.getInterfaceContract() != null && !this.isAsIs()) {
            WebServiceBindingFactory wsFactory = registry.getExtensionPoint(WebServiceBindingFactory.class);
            WebServiceBinding wsBinding = wsFactory.createWebServiceBinding();
            BindingWSDLGenerator.generateWSDL(component, service, wsBinding, registry, null);
            this.interfaceContract = wsBinding.getBindingInterfaceContract();
            this.interfaceContract.getInterface().resetDataBinding(OMElement.class.getName());
            List<Operation> wsdlOpList = this.interfaceContract.getInterface().getOperations();
            for (Operation op : opList) {
                String name = op.getName();
                Operation matchingWsdlOp = null;
                for (Operation wsdlOp : wsdlOpList) {
                    if (!name.equals(wsdlOp.getName())) continue;
                    matchingWsdlOp = wsdlOp;
                    break;
                }
                if (matchingWsdlOp.isInputWrapperStyle() && op.getInputType().getLogical().size() == 1) {
                    ElementInfo ei = op.getInputWrapper().getWrapperElement();
                    String namespace = ei.getQName().getNamespaceURI();
                    String opName = ei.getQName().getLocalPart();
                    OMNamespace ns = factory.createOMNamespace(namespace, "ns1");
                    OMElement wrapper = factory.createOMElement(opName, ns);
                    this.inputWrapperMap.put(name, wrapper);
                }
                if (matchingWsdlOp.isOutputWrapperStyle()) {
                    this.outputWrapperMap.put(name, true);
                    continue;
                }
                this.outputWrapperMap.put(name, false);
            }
        } else {
            this.interfaceContract = service.getService().getInterfaceContract();
        }
    }

    protected boolean isAsIs() {
        InterfaceContract ic = this.service.getInterfaceContract();
        if (ic.getInterface().getOperations().size() != 1) {
            return false;
        }
        List<DataType> inputDataTypes = ic.getInterface().getOperations().get(0).getInputType().getLogical();
        if (inputDataTypes.size() != 1) {
            return false;
        }
        Class<?> inputType = inputDataTypes.get(0).getPhysical();
        return Message.class.isAssignableFrom(inputType);
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null && !this.isAsIs()) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSDefault) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSDefault) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSDefaultServiceInterceptor(this.binding, this.jmsResourceFactory, this.service.getRuntimeWire(this.binding), this.inputWrapperMap, this.outputWrapperMap);
    }

    public String getPhase() {
        return "service.binding.wireformat";
    }
}

