/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.runtime;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.provider.ObjectMessageProcessor;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.WireFormatJMSObject;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireFormatJMSObjectReferenceInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private HashMap<String, String> singleArgMap;

    public WireFormatJMSObjectReferenceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire, HashMap<String, String> hashMap) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        this.singleArgMap = hashMap;
    }

    @Override
    public Message invoke(Message msg) {
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSObject) {
            msg = this.invokeRequest(msg);
        }
        msg = this.getNext().invoke(msg);
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSObject) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            Session session = context.getJmsSession();
            javax.jms.Message requestMsg = this.singleArgMap.get(msg.getOperation().getName()) == null ? this.requestMessageProcessor.insertPayloadIntoJMSMessage(session, msg.getBody()) : ((ObjectMessageProcessor)this.requestMessageProcessor).createJMSMessageForSingleParamOperation(session, msg.getBody(), false);
            msg.setBody(requestMsg);
            requestMsg.setJMSReplyTo(context.getReplyToDestination());
            return msg;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public Message invokeResponse(Message msg) {
        if (msg.getBody() != null) {
            Object response = this.responseMessageProcessor.extractPayloadFromJMSMessage((javax.jms.Message)msg.getBody());
            if (response instanceof InvocationTargetException) {
                msg.setFaultBody(((InvocationTargetException)response).getCause());
            } else if (response != null) {
                msg.setBody(response);
            } else {
                msg.setBody(null);
            }
        }
        return msg;
    }

    @Override
    public Invoker getNext() {
        return this.next;
    }

    @Override
    public void setNext(Invoker next) {
        this.next = next;
    }
}

