/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.runtime;

import java.util.HashMap;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.provider.ObjectMessageProcessor;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.WireFormatJMSObject;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireFormatJMSObjectServiceInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private HashMap<String, Class<?>> singleArgMap;
    private boolean wrapSingle;

    public WireFormatJMSObjectServiceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire, HashMap<String, Class<?>> singleArgMap, boolean wrapSingle) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        this.singleArgMap = singleArgMap;
        this.wrapSingle = wrapSingle;
    }

    @Override
    public Message invoke(Message msg) {
        Operation operation;
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSObject) {
            msg = this.invokeRequest(msg);
        }
        if ((operation = (msg = this.getNext().invoke(msg)).getOperation()) != null && operation.isNonBlocking()) {
            return msg;
        }
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSObject) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = context.getJmsMsg();
        Class<?> argType = this.singleArgMap.get(msg.getOperation().getName());
        Object requestPayload = argType == null ? this.requestMessageProcessor.extractPayloadFromJMSMessage(jmsMsg) : ((ObjectMessageProcessor)this.requestMessageProcessor).extractPayloadFromJMSMessageForSingleParamOperation(jmsMsg, argType, this.wrapSingle);
        if (requestPayload != null && requestPayload.getClass().isArray()) {
            msg.setBody(requestPayload);
        } else if (requestPayload == null) {
            msg.setBody(new Object[0]);
        } else {
            msg.setBody(new Object[]{requestPayload});
        }
        return msg;
    }

    public Message invokeResponse(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        Session session = context.getJmsResponseSession();
        javax.jms.Message responseJMSMsg = null;
        responseJMSMsg = msg.isFault() ? this.responseMessageProcessor.createFaultMessage(session, (Throwable)msg.getBody()) : this.responseMessageProcessor.insertPayloadIntoJMSMessage(session, msg.getBody());
        msg.setBody(responseJMSMsg);
        return msg;
    }

    @Override
    public Invoker getNext() {
        return this.next;
    }

    @Override
    public void setNext(Invoker next) {
        this.next = next;
    }
}

