/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.runtime;

import java.util.HashMap;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.WireFormatJMSObject;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.runtime.WireFormatJMSObjectServiceInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class WireFormatJMSObjectServiceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private JMSBinding binding;
    private InterfaceContract interfaceContract;
    private HashMap<String, Class<?>> singleArgMap;
    private boolean wrapSingle = true;

    public WireFormatJMSObjectServiceProvider(ExtensionPointRegistry registry, RuntimeComponent component, RuntimeComponentService service, Binding binding) {
        this.registry = registry;
        this.component = component;
        this.service = service;
        this.binding = (JMSBinding)binding;
        this.singleArgMap = new HashMap();
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSObject) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.ObjectMessageProcessor");
            List<Operation> opList = service.getService().getInterfaceContract().getInterface().getOperations();
            for (Operation op : opList) {
                if (op.getInputType().getLogical().size() != 1) continue;
                this.singleArgMap.put(op.getName(), op.getInputType().getLogical().get(0).getPhysical());
            }
            this.wrapSingle = ((WireFormatJMSObject)this.binding.getRequestWireFormat()).isWrappedSingleInput();
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSObject) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.ObjectMessageProcessor");
        }
        this.interfaceContract = service.getService().getInterfaceContract();
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSObject) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSObject) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSObjectServiceInterceptor(this.binding, null, this.service.getRuntimeWire(this.binding), this.singleArgMap, this.wrapSingle);
    }

    public String getPhase() {
        return "service.binding.wireformat";
    }
}

