/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmstext.runtime;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstext.WireFormatJMSText;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstext.runtime.WireFormatJMSTextReferenceInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

public class WireFormatJMSTextReferenceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeComponent component;
    private RuntimeComponentReference reference;
    private JMSBinding binding;
    private InterfaceContract interfaceContract;

    public WireFormatJMSTextReferenceProvider(ExtensionPointRegistry registry, RuntimeComponent component, RuntimeComponentReference reference, Binding binding) {
        this.registry = registry;
        this.component = component;
        this.reference = reference;
        this.binding = (JMSBinding)binding;
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSText && this.binding.getRequestMessageProcessorName().equals("org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor")) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.TextMessageProcessor");
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSText && this.binding.getResponseMessageProcessorName().equals("org.apache.tuscany.sca.binding.jms.provider.DefaultMessageProcessor")) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.TextMessageProcessor");
        }
        this.interfaceContract = reference.getReference().getInterfaceContract();
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSText) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSText) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSTextReferenceInterceptor(this.binding, null, this.reference.getRuntimeWire(this.binding));
    }

    public String getPhase() {
        return "reference.binding.wireformat";
    }
}

