/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.runtime;

import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.WireFormatJMSTextXML;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.runtime.WireFormatJMSTextXMLServiceInterceptor;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class WireFormatJMSTextXMLServiceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private JMSBinding binding;
    private JMSResourceFactory jmsResourceFactory;
    private InterfaceContract interfaceContract;

    public WireFormatJMSTextXMLServiceProvider(ExtensionPointRegistry registry, RuntimeComponent component, RuntimeComponentService service, Binding binding, JMSResourceFactory jmsResourceFactory) {
        this.component = component;
        this.service = service;
        this.binding = (JMSBinding)binding;
        this.jmsResourceFactory = jmsResourceFactory;
        if (this.binding.getRequestWireFormat() instanceof WireFormatJMSTextXML) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.XMLTextMessageProcessor");
        }
        if (this.binding.getResponseWireFormat() instanceof WireFormatJMSTextXML) {
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.XMLTextMessageProcessor");
        }
        WebServiceBindingFactory wsFactory = registry.getExtensionPoint(WebServiceBindingFactory.class);
        WebServiceBinding wsBinding = wsFactory.createWebServiceBinding();
        BindingWSDLGenerator.generateWSDL(component, service, wsBinding, registry, null);
        this.interfaceContract = wsBinding.getBindingInterfaceContract();
        this.interfaceContract.getInterface().resetDataBinding(OMElement.class.getName());
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        if (this.interfaceContract != null) {
            if (this.binding.getRequestWireFormat() instanceof WireFormatJMSTextXML) {
                interfaceContract.getInterface().resetInterfaceInputTypes(this.interfaceContract.getInterface());
            }
            if (this.binding.getResponseWireFormat() instanceof WireFormatJMSTextXML) {
                interfaceContract.getInterface().resetInterfaceOutputTypes(this.interfaceContract.getInterface());
            }
        }
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSTextXMLServiceInterceptor(this.binding, this.jmsResourceFactory, this.service.getRuntimeWire(this.binding));
    }

    public String getPhase() {
        return "service.binding.wireformat";
    }
}

