/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.js;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.binding.jsonrpc.JSONRPCBinding;
import org.apache.tuscany.sca.web.javascript.JavascriptProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONRPCBindingJavascriptProxyFactoryImpl
implements JavascriptProxyFactory {
    private static final QName NAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "binding.jsonrpc");
    private static final String JAVASCRIPT_FILE_NAME = "binding-jsonrpc.js";

    @Override
    public Class<?> getModelType() {
        return JSONRPCBinding.class;
    }

    @Override
    public QName getQName() {
        return NAME;
    }

    @Override
    public String getJavascriptProxyFile() {
        return JAVASCRIPT_FILE_NAME;
    }

    @Override
    public InputStream getJavascriptProxyFileAsStream() throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(JAVASCRIPT_FILE_NAME);
        if (is == null) {
            throw new IOException("Could not find Javascript 'binding-jsonrpc.js'");
        }
        return is;
    }

    @Override
    public String createJavascriptReference(ComponentReference componentReference) throws IOException {
        Binding binding = componentReference.getBindings().get(0);
        URI targetURI = URI.create(binding.getURI());
        String targetPath = targetURI.getPath();
        return "JSONRpcClient(\"" + targetPath + "\").Service";
    }
}

