/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaDomainScriptServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected transient List<String> serviceNames = new ArrayList<String>();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletOutputStream os = response.getOutputStream();
        os.println();
        os.println("/* Apache Tuscany scaDomain.js Header */");
        os.println();
        this.writeJSONRPCJavaScript(os);
        this.writeScaDomainCode(os, request.getServletPath());
    }

    protected void writeScaDomainCode(ServletOutputStream out, String path) throws IOException {
        out.println();
        out.println("/* Apache Tuscany scaDomain.js Footer  */");
        out.println();
        out.println("function scaDomain() {}");
        path = path.substring(1);
        for (String serviceName : this.serviceNames) {
            out.println();
            out.println("scaDomain." + serviceName + " = " + "new JSONRpcClient(\"" + serviceName + "\");");
            out.println(serviceName + " = scaDomain." + serviceName + ".Service;");
        }
        out.println();
        out.println("/** End of Apache Tuscany scaDomain.js */");
        out.println();
    }

    protected void writeJSONRPCJavaScript(ServletOutputStream os) throws IOException {
        int i;
        URL url = ((Object)((Object)this)).getClass().getResource("jsonrpc.js");
        InputStream is = url.openStream();
        while ((i = is.read()) != -1) {
            os.write(i);
        }
    }

    public void addService(String serviceName) {
        this.serviceNames.add(serviceName);
    }

    public void removeService(String serviceName) {
        this.serviceNames.remove(serviceName);
    }

    public List<String> getServiceNames() {
        return this.serviceNames;
    }
}

